#include "hubrpc/impl.h"
#include <yxiva/core/types.h>

namespace yxiva {

struct web_subscription
{
    string uid;
    channel_key key;
    string id;
    string callback_url;
    unsigned ttl_hours = 0;
    string priority = {};
};

class xivaws_subscriptions_storage : public yplatform::module
{
public:
    using hubrpc_ptr = std::shared_ptr<hubrpc>;

    xivaws_subscriptions_storage(boost::asio::io_service& io)
    {
        hubrpc_ = yplatform::find<hubrpc, std::shared_ptr>(io, "hubrpc");
    }

    template <typename Handler>
    void subscribe(task_context_ptr ctx, const web_subscription& sub, Handler&& handler)
    {
        typename hubrpc::http_options opt;
        opt.max_attempts = 1;
        hubrpc_->async_get(
            ctx,
            sub.uid,
            "/subscribe",
            { { "service", static_cast<string>(sub.key.service) },
              { "id", sub.id },
              { "uid", sub.uid },
              { "callback", sub.callback_url },
              { "filter", sub.key.filter },
              { "client", sub.key.client },
              { "ttl", sub.ttl_hours },
              { "session_key", sub.key.session },
              { "bb_connection_id", sub.key.bb_connection_id },
              { "position", sub.key.position },
              { "history_count", sub.key.history_count },
              { "strict_position", sub.key.strict_position },
              { "priority", sub.priority } },
            opt,
            std::forward<Handler>(handler));
    }

    template <typename Handler>
    void unsubscribe(task_context_ptr ctx, const web_subscription& sub, Handler&& handler)
    {
        typename hubrpc::http_options opt;
        opt.max_attempts = 1;
        hubrpc_->async_get(
            ctx,
            sub.uid,
            "/unsubscribe",
            { { "service", static_cast<string>(sub.key.service) },
              { "uid", sub.uid },
              { "subscription-id", sub.id },
              { "priority", sub.priority } },
            opt,
            std::forward<Handler>(handler));
    }

private:
    hubrpc_ptr hubrpc_;
};

}

#include <yplatform/module_registration.h>
REGISTER_MODULE(yxiva::xivaws_subscriptions_storage)