#pragma once

#include <ymod_xconf/types.h>
#include <yxiva/core/packing.hpp>
#include <msgpack.hpp>
#include <string>

namespace ymod_xconf {

typedef uint64_t revision_t;

struct item
{
    string configuration;
    string token;
    string name;
    string owner;
    revision_t revision;
    config_type type;
    string environment;

    // WARNING: Do not remove existing fields, add new ones to the end
    MSGPACK_DEFINE(configuration, token, name, owner, revision, type, environment);
};

struct conf_list
{
    revision_t max_revision = 0;
    std::vector<item> items;

    // WARNING: Do not remove existing fields, add new ones to the end
    MSGPACK_DEFINE(max_revision, items);

    string serialize_to_msgpack() const
    {
        return yxiva::pack(*this);
    }

    void deserialize_msgpack(const string& raw)
    {
        yxiva::unpack(raw, *this);
    }
};

typedef std::shared_ptr<conf_list> conf_list_ptr;

} // conf
