#pragma once

#include <ymod_xconf/types.h>
#include <msgpack.hpp>
#include <string>
#include <map>

namespace ymod_xconf {

enum class config_environment
{
    UNKNOWN = -1,

    SANDBOX,
    CORP,
    PRODUCTION,

    COUNT
};

namespace detail {
static const string ENV_SANDBOX("sandbox");
static const string ENV_CORP("corp");
static const string ENV_PRODUCTION("production");

static const std::map<string, config_environment> ALL_ENVS = {
    { ENV_SANDBOX, config_environment::SANDBOX },
    { ENV_CORP, config_environment::CORP },
    { ENV_PRODUCTION, config_environment::PRODUCTION },
};
}

inline const string& get_environment_name(config_environment env)
{
    static const string ENV_UNKNOWN = "unknown";
    switch (env)
    {
    case config_environment::SANDBOX:
        return detail::ENV_SANDBOX;
    case config_environment::CORP:
        return detail::ENV_CORP;
    case config_environment::PRODUCTION:
        return detail::ENV_PRODUCTION;
    default:
        return ENV_UNKNOWN;
    };
}

inline config_environment resolve_environment(const string& name)
{
    auto it = detail::ALL_ENVS.find(name);
    return it == detail::ALL_ENVS.end() ? config_environment::UNKNOWN : it->second;
}

}
