#pragma once

#include <yxiva/core/operation_result.h>
#include <msgpack.hpp>
#include <string>
#include <map>
#include <cassert>

namespace ymod_xconf {

enum class config_type
{
    SERVICE,
    MOBILE,
    SEND_TOKEN,
    LISTEN_TOKEN,
    ANY
};

}

MSGPACK_ADD_ENUM(ymod_xconf::config_type);

namespace ymod_xconf {

namespace detail {
static const string STR_SERVICE("service");
static const string STR_MOBILE("mobile");
static const string STR_SEND_TOKEN("send_token");
static const string STR_LISTEN_TOKEN("listen_token");
static const string STR_ANY("any");

static const std::map<string, config_type> ALL_CONF_TYPES = {
    { detail::STR_SERVICE, config_type::SERVICE },
    { detail::STR_MOBILE, config_type::MOBILE },
    { detail::STR_SEND_TOKEN, config_type::SEND_TOKEN },
    { detail::STR_LISTEN_TOKEN, config_type::LISTEN_TOKEN },
    { detail::STR_ANY, config_type::ANY }
};
} // detail

inline const string& get_type_name(config_type type)
{
    switch (type)
    {
    case config_type::SERVICE:
        return detail::STR_SERVICE;
    case config_type::MOBILE:
        return detail::STR_MOBILE;
    case config_type::SEND_TOKEN:
        return detail::STR_SEND_TOKEN;
    case config_type::LISTEN_TOKEN:
        return detail::STR_LISTEN_TOKEN;
    case config_type::ANY:
        return detail::STR_ANY;
    };
    assert(false && "unknown config_type");
}

inline yxiva::operation::result resolve_type(const string& name, config_type& type)
{
    auto itype = detail::ALL_CONF_TYPES.find(name);
    if (itype == detail::ALL_CONF_TYPES.cend())
    {
        return "unknown config type";
    }
    type = itype->second;
    return yxiva::operation::success;
}

} // conf
