#pragma once

#include <ymod_xconf/conf_list.h> // revision_t
#include <ymod_xconf/error.h>
#include <ymod_pq/response_handler.h>
#include <string>

namespace ymod_xconf {

struct put_handler : public ymod_pq::response_handler
{
    revision_t revision = 0;
    error_code errc = error::success;

    enum COLUMNS
    {
        REVISION = 0,
        ERROR_STR,
        COUNT
    };

    void handle_cell(unsigned /*row*/, unsigned col, const string& value, bool is_null)
    {
        try
        {
            switch (col)
            {
            case REVISION:
                revision = is_null ? 0 : boost::lexical_cast<revision_t>(value);
                break;
            case ERROR_STR:
                if (value == "bad_owner_id") errc = error::bad_owner_id;
                else if (value == "token_violation")
                    errc = error::token_violation;
                else if (value == "stale_revision")
                    errc = error::stale_revision;
                break;
            default:
                break;
            }
        }
        catch (const boost::bad_lexical_cast& ex)
        {
            YLOG_G(error) << "bad cast error: column=" << col << " exception=\"" << ex.what()
                          << "\""
                          << " value=\"" << value << "\"";
            errc = error::transport_error;
        }
        catch (const std::exception& ex)
        {
            YLOG_G(error) << "error on select: column=" << col << " exception=\"" << ex.what()
                          << "\""
                          << " value=\"" << value << "\"";
            errc = error::transport_error;
        }
    }

    unsigned column_count() const
    {
        return COLUMNS::COUNT;
    }
};

} // conf
