#pragma once

#include <ymod_xconf/xconf.h>

namespace ymod_xconf {

class fake_client : public client
{
public:
    fake_client()
    {
    }

protected:
    void put_impl(
        config_type /*type*/,
        const string& /*environment*/,
        const string& /*name*/,
        const string& /*owner*/,
        const string& /*token*/,
        revision_t /*revision*/,
        string_ptr /*value*/,
        const put_handler_t& handler,
        task_context_ptr /*ctx*/) override
    {
        yplatform::safe_call("xconf handler", handler, error::transport_error, INITIAL_REVISION);
    }

    void list_impl(
        config_type /*type*/,
        const string& /*environment*/,
        revision_t revision,
        const conf_list_handler_t& handler,
        task_context_ptr /*ctx*/) override
    {
        auto configurations = std::make_shared<conf_list>();
        configurations->max_revision = revision;
        yplatform::safe_call("xconf handler", handler, error::success, configurations);
    }
};

} // conf
