#pragma once

#include <ymod_xconf/types.h>
#include <ymod_xconf/xconf.h>

namespace ymod_xconf {

typedef std::function<void(conf_list_ptr)> no_error_conf_list_handler_t;

class local_conf_storage : public client
{
public:
    virtual void subscribe_updates(
        config_type type,
        config_environment environment,
        no_error_conf_list_handler_t&& handler)
    {
        subscribe_updates_impl(type, get_environment_name(environment), std::move(handler));
    }

    // Allow to subscribe for all available environments implicitly.
    void subscribe_updates(config_type type, no_error_conf_list_handler_t&& handler)
    {
        subscribe_updates_impl(type, string{}, std::move(handler));
    }

protected:
    virtual void subscribe_updates_impl(
        config_type type,
        const string& environment,
        no_error_conf_list_handler_t&& handler) = 0;
};

typedef boost::shared_ptr<local_conf_storage> local_conf_storage_ptr;

} // conf
