#pragma once

#include <ymod_xconf/types.h>
#include <ymod_xconf/config_environment.h>
#include <ymod_xconf/config_type.h>
#include <ymod_xconf/conf_list.h>
#include <ymod_xconf/error.h>
#include <yxiva/core/iabstract.h>
#include <yplatform/task_context.h>
#include <yplatform/util/safe_call.h>

namespace ymod_xconf {

using yplatform::task_context_ptr;

typedef std::function<void(const error_code&, revision_t)> put_handler_t;
typedef std::function<void(const error_code&, conf_list_ptr)> conf_list_handler_t;

typedef boost::shared_ptr<string> string_ptr;

const revision_t INITIAL_REVISION = 0;

class client : public yxiva::iabstract
{
public:
    virtual void put(
        config_type type,
        config_environment environment,
        const string& name,
        const string& owner,
        const string& token,
        revision_t revision,
        string_ptr value,
        const put_handler_t& handler,
        task_context_ptr ctx)
    {
        put_impl(
            type,
            get_environment_name(environment),
            name,
            owner,
            token,
            revision,
            value,
            handler,
            ctx);
    }

    // Allow to put environment-indifferent items implicitly.
    void put(
        config_type type,
        const string& name,
        const string& owner,
        const string& token,
        revision_t revision,
        string_ptr value,
        const put_handler_t& handler,
        task_context_ptr ctx)
    {
        put_impl(type, string{}, name, owner, token, revision, value, handler, ctx);
    }

    /* When no config items selected the list_with_revision is supposed to contain empty list and
     * max_revision >= requested revision
     */
    virtual void list(
        config_type type,
        config_environment environment,
        revision_t revision,
        const conf_list_handler_t& handler,
        task_context_ptr ctx)
    {
        list_impl(type, get_environment_name(environment), revision, handler, ctx);
    }

    // Allow to list all available environments implicitly.
    void list(
        config_type type,
        revision_t revision,
        const conf_list_handler_t& handler,
        task_context_ptr ctx)
    {
        list_impl(type, string{}, revision, handler, ctx);
    }

protected:
    virtual void put_impl(
        config_type type,
        const string& environment,
        const string& name,
        const string& owner,
        const string& token,
        revision_t revision,
        string_ptr value,
        const put_handler_t& handler,
        task_context_ptr ctx) = 0;

    virtual void list_impl(
        config_type type,
        const string& environment,
        revision_t revision,
        const conf_list_handler_t& handler,
        task_context_ptr ctx) = 0;
};

typedef std::shared_ptr<client> xconf_ptr;
} // conf
