#pragma once

#include <ymod_xconf/local_conf_storage.h>
#include "timer_based_poller.h"
#include "fs_conf_dumper.h"
#include <ymod_xconf/xconf.h>
#include <ymod_httpclient/cluster_client.h>
#include <yplatform/module.h>
#include <yplatform/reactor.h>

namespace ymod_xconf {

class local_conf_storage_impl
    : public local_conf_storage
    , public yplatform::module
{
    using key_t = std::pair<config_type, string>;

public:
    local_conf_storage_impl(const yplatform::ptree& conf);
    void start();
    void stop();

protected:
    void put_impl(
        config_type type,
        const string& environment,
        const string& name,
        const string& owner,
        const string& token,
        revision_t revision,
        string_ptr value,
        const put_handler_t& handler,
        task_context_ptr ctx) override;
    void list_impl(
        config_type type,
        const string& environment,
        revision_t revision,
        const conf_list_handler_t& handler,
        task_context_ptr ctx) override;

private:
    timer_based_poller_ptr find_or_create_poller(config_type type, const string& environment);
    void load_setting(const yplatform::ptree& module_conf);
    void call_handlers(config_type type, const string& environment, conf_list_ptr confs);
    void subscribe_updates_impl(
        config_type type,
        const string& environment,
        no_error_conf_list_handler_t&& handler) override;

private:
    struct
    {
        time_duration poll_interval;
        string condb_http_api_host;
        bool dump_to_filesystem;
        string dump_dir_path;
        yhttp::cluster_client::settings http;
    } settings_;

    xconf_ptr confdb_;
    std::shared_ptr<fs_conf_dumper> confs_dumper_;
    std::map<key_t, timer_based_poller_ptr> pollers_;
    std::map<key_t, std::vector<no_error_conf_list_handler_t>> handlers_by_conf_props_;
    std::shared_ptr<yplatform::reactor> reactor_;
};

} // conf
