#pragma once

#include <ymod_xstore/types.h>
#include <boost/system/error_code.hpp>

namespace ymod_xstore {

using boost::system::error_code;

enum err_code {
  err_code_no_error = 0,
  err_code_unknown = 1,
  err_code_storage_fail,
  err_code_call_fail,
};

/// See boost::system description
class error_category : public boost::system::error_category
{
public:
  /// yabbclient error category name.
  const char* name() const noexcept (true)
  { return "xstore"; }

  /// accessor to yabbclient error descriptions index.
  string message(int ev) const
  { return error_names.at(ev); }

private:
  /// error descriptions index.
  static const std::vector<string> error_names;
};

const error_category& category();

/*! \brief Error container.
 *
 *  Contains error_code structure and extended string reason for logging.
 */
struct error {
  error (err_code err = err_code_no_error, const string& ext_reason = "")
    : code (err, category()), ext_reason (ext_reason)
  {}

  /// true if error found.
  operator bool() const
  { return code.value(); }

  error_code code;
  string ext_reason;
};

/// Create error object from code and reason
inline error make_error (err_code err, const string& ext_reason = "")
{ return error(err, ext_reason); }

}
