#pragma once

#include <ymod_xstore/types.h>
#include <ymod_xstore/error.h>
#include <yxiva/core/shards/storage.h>
#include <yplatform/module.h>
#include <yplatform/future/future.hpp>
#include <boost/function.hpp>
#include <vector>

namespace ymod_xstore {

typedef boost::function<void(const error&)> callback_t;
typedef boost::function<void(const error&, const local_id_t, const std::time_t, merge_type, const string&)> insert_callback_t;
typedef boost::function<void(const error&, entries_list_ptr)> entries_callback_t;
typedef boost::function<void(const error&, const counter_pack&)> counters_callback_t;
typedef boost::function<void(const error&, const range_counters_list&)> range_counters_list_callback_t;
typedef boost::function<void(const error&, unsigned long)> lift_messages_callback_t;

class xstore {
public:
    virtual ~xstore() {}
    virtual void write(task_context_ptr ctx, entry&& entry,
        const string& hash, const insert_callback_t& cb) = 0;

    virtual void read(task_context_ptr ctx, const user_id & uid,
              const string & service, const local_id_t local_id_from,
              const local_id_t local_id_to, const unsigned limit,
              const time_t begin_ts, const time_t end_ts,
              const entries_callback_t& cb) = 0;

    virtual void read(task_context_ptr ctx, const user_id & uid,
              const string & service, const local_id_t local_id_from,
              const unsigned limit, const time_t begin_ts, const time_t end_ts,
              const entries_callback_t& cb) = 0;

    virtual void read(task_context_ptr ctx,
              const user_id & uid,
              const std::vector<string> & services,
              const unsigned last_hours,
              const unsigned limit,
              const entries_callback_t& cb) = 0;

    virtual void get_counters(task_context_ptr ctx, const user_id& uid,
        const std::vector<string> & services, const counters_callback_t& cb) = 0;

    virtual void get_range_counters(task_context_ptr ctx, const user_id& uid,
        const std::vector<string> & services, time_t begin_ts,
        local_id_t local_id_from, size_t count,
        const range_counters_list_callback_t& cb) = 0;

    virtual void lift_messages(task_context_ptr ctx, const string& uid,
      const string& service, local_id_t local_id_from, size_t count,
      const lift_messages_callback_t& cb) = 0;

    virtual std::shared_ptr<yxiva::shard_config::storage> shards() = 0;
    virtual bool in_fallback() = 0;
    virtual void enable_fallback(task_context_ptr ctx) = 0;
    virtual void disable_fallback(task_context_ptr ctx) = 0;
};

} // namespace ymod_xstore
