#pragma once

#include <vector>
#include <string>
#include <yplatform/task_context.h>
#include <yxiva/core/types.h>
#include <yxiva/core/message.h>

namespace ymod_xstore
{

using std::string;
using yplatform::task_context;
using yplatform::task_context_ptr;

typedef yxiva::user_id user_id;
typedef yxiva::ttl_t ttl_t;
typedef yxiva::local_id_t local_id_t;

struct entry
{
  user_id uid;
  string service;
  local_id_t local_id {0};
  string content;
  std::time_t event_ts {0};
  std::vector<string> tags;
  ttl_t ttl {0};
  bool is_deleted {false};
  bool is_sticked {false};
  std::time_t delayed_until_ts {0};
  string transit_id;
  string topic;

  entry() = default;

  entry(user_id uid_, string service_) :
  uid(uid_),
  service(service_)
  {
  }
};

typedef std::vector<entry> entries_list;
// @todo: why?
typedef boost::shared_ptr<entries_list> entries_list_ptr;

struct counter_set
{
  local_id_t seen;
  local_id_t top;
  time_t seen_dt;

  counter_set()
    : seen(0), top(0)
  {
  }

  local_id_t count () const
  {
    return top > seen ? top - seen : 0;
  }
};

typedef std::map<string, counter_set> counter_pack;

class entry_task : public task_context
{
public:

  entry_task() : name("xstore_entry_task")
  {
  }

  const string& get_name() const
  {
    return name;
  }

private:
  const string name;
};

typedef boost::shared_ptr<entry_task> entry_task_ptr;

enum class merge_type
{
  none,
  duplicate,
  topic
};

merge_type merge_type_from_string(const string& s);
const string& to_string(merge_type m);

struct range_counters
{
    user_id uid;
    string service;
    local_id_t top = 0;
    local_id_t bottom = 0;
};

using range_counters_list = std::vector<range_counters>;

}
