#pragma once


#include <ymod_xstore/types.h>
#include <yxiva/core/iabstract.h>
#include <ymod_pq/response_handler.h>
#include <boost/lexical_cast.hpp>
#include <string>

namespace ymod_xstore
{
namespace pq_handler
{

class get_counters
  : public ymod_pq::response_handler, public yxiva::iabstract
{
private:
  string current_service_;
  counter_set current_;
  counter_pack counters_;

public:

  enum
  {
    uid,
    service_name,
    unseen_count,
    next_local_id,
    last_seen_id,
    last_seen_dt,

    column_cnt
  };

  get_counters()
  {
  }

  void handle_cell(unsigned /*row*/, unsigned col, const string& value,
      bool is_null)
  {
    switch (col) {
      case uid:
        // ignore
        break;
      case service_name:
        current_service_ = value;
        break;
      case unseen_count:
        // ignore
        break;
      case next_local_id:
        current_.top = is_null || value.empty() ? 0 : boost::lexical_cast<local_id_t>(value) - 1;
        break;
      case last_seen_id:
        current_.seen = is_null || value.empty() ? 0 : boost::lexical_cast<local_id_t>(value);
        break;
      case last_seen_dt:
        current_.seen_dt = is_null || value.empty() ? 0 : boost::lexical_cast<time_t>(value);
        break;
      default:
        YLOG_L(error) << "[pq_handlers::get_counters] unknown column " << col;
    }
  }

  void handle_row_begin(unsigned /*row*/)
  {
    current_service_ = "";
    current_ = counter_set();
  }

  void handle_row_end(unsigned /*row*/)
  {
    if (current_service_ != "") {
      counters_[current_service_] = current_;
    }
  }

  unsigned column_count() const
  {
    return column_cnt;
  }

  const counter_pack& data() const
  {
    return counters_;
  }
};

}
}
