#pragma once

#include <boost/lexical_cast.hpp>
#include <string>
#include <ymod_pq/response_handler.h>
#include <ymod_xstore/types.h>
#include <yxiva/core/iabstract.h>

namespace ymod_xstore {
namespace pq_handler {

class get_range_counters : public ymod_pq::response_handler
{
private:
    range_counters current_;
    range_counters_list result_;

public:
    enum
    {
        uid,
        service_name,
        start_local_id,
        top_local_id,

        column_cnt
    };

    get_range_counters() {}

    void handle_cell(
      unsigned /*row*/, unsigned col, const string& value, bool is_null)
    {
        switch (col) {
            case uid:
                current_.uid = value;
                break;
            case service_name:
                current_.service = value;
                break;
            case start_local_id:
                current_.bottom = is_null || value.empty()
                                    ? 0
                                    : boost::lexical_cast<local_id_t>(value);
                break;
            case top_local_id:
                current_.top = is_null || value.empty()
                                 ? 0
                                 : boost::lexical_cast<local_id_t>(value);
                break;
            default:
                YLOG_L(error)
                  << "[pq_handlers::range_counters] unknown column " << col;
        }
    }

    void handle_row_begin(unsigned /*row*/) { current_ = range_counters(); }

    void handle_row_end(unsigned /*row*/)
    {
        result_.push_back(current_);
    }

    unsigned column_count() const { return column_cnt; }

    const range_counters_list& data() const { return result_; }
};
}
}
