#pragma once


#include <ymod_xstore/types.h>
#include <yxiva/core/iabstract.h>
#include <ymod_pq/response_handler.h>
#include <boost/lexical_cast.hpp>
#include <string>

namespace ymod_xstore
{
namespace pq_handler
{

class insert
  : public ymod_pq::response_handler, public yxiva::iabstract
{
private:
  local_id_t local_id_ = 0;
  std::time_t event_ts_ = 0;
  merge_type merge_ = merge_type::none;
  string transit_id_;

public:
  enum
  {
    column_local_id,
    column_event_ts,
    column_merge_type,
    column_transit_id,

    column_cnt
  };

  void handle_cell(unsigned /*row*/, unsigned col, const string& value,
      bool is_null)
  {
    switch (col) {
      case column_local_id:
        local_id_ = is_null || value.empty() ? 0 : boost::lexical_cast<local_id_t>(value);
        break;
      case column_event_ts:
        event_ts_ = is_null || value.empty() ? 0 : boost::lexical_cast<std::time_t>(value);
        break;
      case column_merge_type:
        merge_ = merge_type_from_string(value);
        break;
      case column_transit_id:
        transit_id_ = is_null ? "" : value;
        break;
      default:
        YLOG_L(error) << "[pq_handlers::insert] unknown column " << col;
    }
  }

  void handle_row_begin(unsigned /*row*/)
  {
  }

  void handle_row_end(unsigned /*row*/)
  {
  }

  unsigned column_count() const
  {
    return column_cnt;
  }

  local_id_t local_id() const
  {
    return local_id_;
  }

  std::time_t event_ts() const
  {
    return event_ts_;
  }

  const string& transit_id() const
  {
    return transit_id_;
  }

  merge_type merge() const
  {
    return merge_;
  }
};

}
}
