#pragma once

#include <yxiva/core/iabstract.h>
#include <ymod_pq/response_handler.h>
#include <string>

namespace ymod_xstore { namespace pq_handler {

class lift_messages: public ymod_pq::response_handler
{
    unsigned long count = 0;
public:

    void handle_cell(unsigned /*row*/, unsigned /*col*/,
      const string& value, bool is_null) override
    {
        if (is_null) return;
        count = stoul(value);
    }

    unsigned column_count() const override
    {
        return 1;
    }

    unsigned long data()
    {
        return count;
    }
};

}}
