#include <ymod_xstore/types.h>

static const std::string NONE = "none";
static const std::string DUPLICATE = "duplicate";
static const std::string TOPIC = "topic";

namespace ymod_xstore
{

merge_type merge_type_from_string(const string& s)
{
  if (s == NONE) return merge_type::none;
  if (s == DUPLICATE) return merge_type::duplicate;
  if (s == TOPIC) return merge_type::topic;

  throw std::invalid_argument("invalid merge_type string '" + s + "'");
}

const string& to_string(merge_type m)
{
  switch (m)
  {
    case merge_type::none: return NONE;
    case merge_type::duplicate: return DUPLICATE;
    case merge_type::topic: return TOPIC;
  }

  throw std::invalid_argument("unknown merge_type");
}


}
