#pragma once

#include <ymod_xstore/interface.h>
#include <ymod_xstore/types.h>
#include <yxiva/core/types.h>
#include <yplatform/module.h>
#include <yplatform/module_registration.h>
#include <yplatform/ptree.h>
#include <yplatform/repository.h>
#include <yplatform/find.h>
#include <yplatform/log.h>
#include <ymod_pq/call.h>
#include <msgpack.hpp>
#include <string>

namespace ymod_xstore
{

using std::string;

class xstore_postgre
  : public xstore, public yplatform::module
{
public:
  void init(const yplatform::ptree&);
  void reload(const yplatform::ptree&);
  void start();
  void stop();
  void fini();

  void write(task_context_ptr ctx, entry&& entry, const string& hash,
      const insert_callback_t& cb) override;

  void read(task_context_ptr ctx, const user_id & uid, const string & service,
      const local_id_t local_id_from, const unsigned limit,
      const time_t begin_ts, const time_t end_ts,
      const entries_callback_t& cb) override;

  void read(task_context_ptr ctx, const user_id & uid, const string & service,
      const local_id_t local_id_from, const local_id_t local_id_to,
      const unsigned limit, const time_t begin_ts, const time_t end_ts,
      const entries_callback_t& cb) override;

  void read(task_context_ptr ctx, const user_id & uid,
      const std::vector<string> & services, const unsigned last_hours,
      const unsigned limit, const entries_callback_t& cb) override;

  void get_counters(task_context_ptr ctx, const user_id& uid,
      const std::vector<string> & services, const counters_callback_t& cb) override;

  void get_range_counters(task_context_ptr ctx,
      const user_id& uid, const std::vector<string> & services, time_t begin_ts,
      local_id_t local_id_from, size_t count, const range_counters_list_callback_t& cb) override;

  void lift_messages(task_context_ptr ctx, const string& uid,
      const string& service, local_id_t local_id_from, size_t count,
      const lift_messages_callback_t& cb) override;

  std::shared_ptr<yxiva::shard_config::storage> shards() override;
  virtual bool in_fallback() override;
  virtual void enable_fallback(task_context_ptr ctx) override;
  virtual void disable_fallback(task_context_ptr ctx) override;

private:
  static constexpr yplatform::time_traits::duration req_deadline =
      yplatform::time_traits::duration::max();

  void read_single_service_impl(task_context_ptr ctx, const user_id & uid, const string & service,
      const local_id_t local_id_from, const local_id_t* local_id_to,
      const unsigned limit, const time_t begin_ts, const time_t end_ts,
      const entries_callback_t& cb);

  boost::shared_ptr<ymod_pq::cluster_call> pq_caller_;
  std::shared_ptr<yxiva::shard_config::storage> shards_;
};

} // namespace ymod_xstore
