#pragma once

#include <ymod_xtasks/types.h>
#include <msgpack.hpp>

namespace ymod_xtasks {

struct delayed_info
{
    ymod_xtasks::task task;
    time_t start_time;
    time_t delay_sec;
    unsigned events_while_wait;

    MSGPACK_DEFINE(task, start_time, delay_sec, events_while_wait);
};

struct active_info
{
    ymod_xtasks::task task;
    string worker;
    time_t start_time;

    MSGPACK_DEFINE(task, worker, start_time);
};

struct worker_info
{
    string worker;
    size_t active_tasks;
    time_t last_seen;

    void update_last_seen(const time_t time) {
        if (last_seen < time) {
            last_seen = time;
        }
    }

    MSGPACK_DEFINE(worker, active_tasks, last_seen);
};

struct create_task_result
{
    task_id_t task_id;
    string action;

    MSGPACK_DEFINE(task_id, action)
};

struct get_tasks_result
{
    std::vector<task> tasks;

    MSGPACK_DEFINE(tasks)
};

struct fin_task_result
{
    fin_task_result() : success(false) {}
    bool success;
    MSGPACK_DEFINE(success)
};

struct delay_task_result
{
    delay_task_result() : success(false) {}
    bool success;
    MSGPACK_DEFINE(success)
};

struct alive_result
{
    alive_result() : success(false) {}
    bool success;
    MSGPACK_DEFINE(success)
};

struct cleanup_active_result
{
    cleanup_active_result() : count(0) {}

    size_t count;
    MSGPACK_DEFINE(count)
};

struct cleanup_workers_result
{
    cleanup_workers_result() : count(0) {}

    size_t count;
    MSGPACK_DEFINE(count)
};

struct wakeup_delayed_result
{
    wakeup_delayed_result() : count(0) {}

    size_t count;
    MSGPACK_DEFINE(count)
};

struct clear_result
{
    clear_result() : count(0) {}

    size_t count;
    MSGPACK_DEFINE(count)
};

struct all_counters_result
{
    all_counters_result()
    : total(0)
    , pending(0)
    , active(0)
    , delayed(0)
    , workers(0)
    {}

    size_t total;
    size_t pending;
    size_t active;
    size_t delayed;
    size_t workers;

    MSGPACK_DEFINE(total, pending, active, delayed, workers)
};

struct pending_list_result
{
    std::vector<task> tasks;

    MSGPACK_DEFINE(tasks)
};

struct active_list_result
{
    std::vector<active_info> tasks;

    MSGPACK_DEFINE(tasks)
};

struct delayed_list_result
{
    std::vector<delayed_info> tasks;

    MSGPACK_DEFINE(tasks)
};

struct worker_list_result
{
    std::vector<worker_info> workers;

    MSGPACK_DEFINE(workers)
};

struct lookup_task_result
{
    string state;
    MSGPACK_DEFINE(state)
};

}