#pragma once

#include <ymod_xtasks/types.h>
#include <ymod_xtasks/iabstract.h>
#include <msgpack.hpp>
#include <type_traits>

namespace ymod_xtasks {

typedef uint64_t local_id_t;
typedef string task_id_t;

namespace delay_flags {

enum : uint32_t
{
    none = 0x0,
    wakeup_on_create = 0x1,
    ignore_if_pending = 0x2
};

}

using delay_flags_t = std::underlying_type<decltype(delay_flags::none)>::type;

}

namespace ymod_xtasks {

struct task_draft
{
    string uid;
    string service;
    local_id_t local_id;
    string hint; // unused
    delay_flags_t delay_flags;

    MSGPACK_DEFINE(uid, service, local_id, hint, delay_flags);
};

struct task
{
    task_id_t id;
    string uid;
    string service;
    local_id_t local_id;

    MSGPACK_DEFINE(id, uid, service, local_id);
};

}
