#pragma once

#include <yplatform/log.h>
#include <yplatform/task_context.h>
#include <boost/shared_ptr.hpp>
#include <string>
#include <memory>
#include <mutex>

namespace ymod_xtasks {

  typedef std::string string;
  typedef std::size_t size_t;

  typedef yplatform::task_context task_context;
  typedef yplatform::task_context_ptr task_context_ptr;

  using std::auto_ptr;
  using boost::shared_ptr;
  using boost::weak_ptr;
  using boost::make_shared;
  using boost::enable_shared_from_this;

  using std::mutex;
  using scoped_lock = std::unique_lock<mutex>;

}