#pragma once

#include <ymod_xtasks/types.h>
#include <ymod_xtasks/iabstract.h>
#include <ymod_xtasks/error.h>
#include <ymod_xtasks/task.h>
#include <ymod_xtasks/results.h>
#include <functional>
#include <vector>

namespace ymod_xtasks {

typedef std::function<void (const error&)> simple_callback;
typedef std::function<void (const error&, const std::vector<task>& result)> tasks_callback;
typedef std::function<void (const error&, const size_t count)> counter_callback;
typedef std::function<void (const error&, const all_counters_result& result)> all_counters_list_callback;

class xtasks : public iabstract
{
public:
    virtual void create_task(const task_context_ptr& ctx, const task_draft& task, const simple_callback& cb) = 0;
    virtual void get_tasks(const task_context_ptr& ctx, const string& worker, const unsigned count, const tasks_callback& cb) = 0;
    virtual void fin_task(const task_context_ptr& ctx, const string& worker, const task_id_t& task_id, const simple_callback& cb) = 0;
    virtual void delay_task(const task_context_ptr& ctx, const string& worker, const task_id_t& task_id, const time_t delay_sec, const simple_callback& cb) = 0;
    virtual void delay_task_shallow(const task_context_ptr& ctx, const string& worker, const task_id_t& task_id, const time_t delay_sec, const simple_callback& cb) = 0;
    virtual void alive(const task_context_ptr& ctx, const string& worker, const simple_callback& cb) = 0;
    virtual void cleanup_active(const task_context_ptr& ctx, const time_t interval, const counter_callback& cb) = 0;
    virtual void cleanup_workers(const task_context_ptr& ctx, const time_t interval, const counter_callback& cb) = 0;
    virtual void wakeup_delayed(const task_context_ptr& ctx, const counter_callback& cb) = 0;
    virtual void clear(const task_context_ptr& ctx, const counter_callback& cb) = 0;

    virtual void get_all_counters(const task_context_ptr& ctx, const all_counters_list_callback& cb) = 0;
    virtual string get_summary_json() = 0;
};

}
