#pragma once

#include "packing.h"
#include "database/results.h"
#include <ymod_xtasks/error.h>
#include <ymod_xtasks/types.h>
#include <ymod_xtasks/xtasks.h>
#include <ymod_paxos/caller.h>
#include <functional>

namespace ymod_xtasks {

class base_caller : public ymod_paxos::icaller
{
public:
    void set_attribute(string const& name, string const& value){
        if (name == "error") {
            error_ = make_error(err_code_exec_failed, value);
        }
    }

protected:
    error error_;
};

template<typename Result>
class simple_caller : public base_caller
{
public:
    simple_caller (const simple_callback& cb) : cb_(cb) {}

    void set_result(string const& /*task_id*/, string const& data) {
        proc_result<Result> result;
        if (!error_ && data != "") {
            unpack_str(data, result);
            error_ = make_error(result.error.code, result.error.ext_reason);
        }
        cb_(error_);
    }

    void set_error(string const& task_id, ymod_paxos::error const& e) {
        error_ = make_error(err_code_exec_failed,
            "task " + task_id + " " + boost::lexical_cast<string>(e.code()) + " " + e.what());
        cb_(error_);
    }

protected:
    proc_result<Result> result_;
    simple_callback cb_;
};

template<typename Result>
class counter_caller : public base_caller
{
public:
    counter_caller (const counter_callback& cb) : cb_(cb) {}

    void set_result(string const& /*task_id*/, string const& data) {
        proc_result<Result> result;
        if (!error_ && data != "") {
            unpack_str(data, result);
            error_ = make_error(result.error.code, result.error.ext_reason);
        }
        cb_(error_, result.data.count);
    }

    void set_error(string const& /*task_id*/, ymod_paxos::error const& e) {
        error_ = make_error(err_code_exec_failed, boost::lexical_cast<string>(e.code()) + " " + e.what());
        cb_(error_, 0);
    }

protected:
    proc_result<Result> result_;
    counter_callback cb_;
};

template<typename Result>
class tasks_caller : public base_caller
{
public:
    tasks_caller (const tasks_callback& cb) : cb_(cb) {}

    void set_result(string const& /*task_id*/, string const& data) {
        proc_result<Result> result;
        if (!error_ && data != "") {
            unpack_str(data, result);
            error_ = make_error(result.error.code, result.error.ext_reason);
        }
        cb_(error_, result.data.tasks);
    }

    void set_error(string const& /*task_id*/, ymod_paxos::error const& e) {
        error_ = make_error(err_code_exec_failed, boost::lexical_cast<string>(e.code()) + " " + e.what());
        cb_(error_, std::vector<task>());
    }

protected:
    proc_result<Result> result_;
    tasks_callback cb_;
};

template<typename Result>
class result_caller : public base_caller
{
public:
    typedef std::function<void (const error&, const Result&)> Callback;
    result_caller (const Callback& cb) : cb_(cb) {}

    void set_result(string const& /*task_id*/, string const& data) {
        proc_result<Result> result;
        if (!error_ && data != "") {
            unpack_str(data, result);
            error_ = make_error(result.error.code, result.error.ext_reason);
        }
        cb_(error_, result.data);
    }

    void set_error(string const& /*task_id*/, ymod_paxos::error const& e) {
        error_ = make_error(err_code_exec_failed, boost::lexical_cast<string>(e.code()) + " " + e.what());
        cb_(error_, Result());
    }

protected:
    proc_result<Result> result_;
    Callback cb_;
};

}
