#pragma once

#include "events.h"
#include <ymod_paxos/packing.hpp>

namespace ymod_xtasks {

template <typename T>
inline T get_value(event_t const& event, const string& param_name)
{
    auto it = event.params.find(param_name);
    if (it != event.params.end())
    {
        T t;
        ymod_paxos::unpack(it->second, t);
        return t;
    }
    else
    {
        throw std::runtime_error("no " + param_name + " in event");
    }
}

template <typename T>
inline shared_ptr<T> get_shared_value(event_t const& event, const string& param_name)
{
    auto it = event.params.find(param_name);
    if (it != event.params.end())
    {
        std::shared_ptr<T> t = std::make_shared<T>();
        ymod_paxos::unpack(it->second, *t);
        return t;
    }
    else
    {
        throw std::runtime_error("no " + param_name + " in event");
    }
}
}