#include "operations.h"
#include <boost/assign/list_of.hpp>
#include <map>

namespace ymod_xtasks {

#define ADD_OP(e) (static_cast<int>(opcodes::e), #e)

const std::map<int, string> OP_SYMBOLS = boost::assign::map_list_of
        ADD_OP(none)
        ADD_OP(create_task)
        ADD_OP(get_tasks)
        ADD_OP(fin_task)
        ADD_OP(delay_task)
        ADD_OP(alive)
        ADD_OP(cleanup_active)
        ADD_OP(cleanup_workers)
        ADD_OP(wakeup_delayed)
        ADD_OP(get_all_counters)
        ADD_OP(get_data_summary)
        ADD_OP(clear)
    ;


namespace opcodes {

const string OP_BAD("unknown");

const string& symbolic(type code)
{
    auto it = OP_SYMBOLS.find(static_cast<int>(code));
    return (it != OP_SYMBOLS.end()) ? it->second : OP_BAD;
}

const string& symbolic(unsigned code)
{
    auto it = OP_SYMBOLS.find(static_cast<int>(code));
    return (it != OP_SYMBOLS.end()) ? it->second : OP_BAD;
}

}


}
