#pragma once

#include "results.h"
#include <ymod_xtasks/types.h>
#include <ymod_xtasks/task.h> // task_id_t
#include <ymod_paxos/types.h>
#include <ymod_paxos/operation.h>
#include <boost/lexical_cast.hpp>

namespace ymod_xtasks {

using ymod_paxos::iid_t;
using ymod_paxos::operation;

namespace opcodes {

enum type
{
    none = 0,
    create_task,
    get_tasks,
    fin_task,
    delay_task,
    alive,
    cleanup_active,
    cleanup_workers,
    wakeup_delayed,
    get_all_counters,
    get_data_summary,
    clear,
};

const string& symbolic(type code);
const string& symbolic(unsigned code);

}

using create_task_args = task_draft;

struct get_tasks_args
{
    string worker;
    unsigned count;
    time_t ts;
    MSGPACK_DEFINE(worker, count, ts);
};

struct fin_task_args
{
    string worker;
    task_id_t task_id;
    time_t ts;
    MSGPACK_DEFINE(task_id, worker, ts);
};

struct delay_task_args
{
    string worker;
    task_id_t task_id;
    time_t delay_sec;
    time_t ts;
    delay_flags_t flags;
    MSGPACK_DEFINE(task_id, worker, delay_sec, ts, flags);
};

struct alive_args
{
    string worker;
    time_t ts;
    MSGPACK_DEFINE(worker, ts);
};

struct cleanup_active_args
{
    time_t ts;
    time_t max_activity_time;
    MSGPACK_DEFINE(max_activity_time, ts);
};

struct cleanup_workers_args
{
    time_t ts;
    time_t max_activity_time;
    MSGPACK_DEFINE(max_activity_time, ts);
};

struct wakeup_delayed_args
{
    time_t ts;
    MSGPACK_DEFINE(ts);
};

template<unsigned OpCode>
struct op_traits;

#define DECL_OP_TRAITS(op) \
template<> \
struct op_traits<opcodes::op> \
{ \
    using args = op##_args; \
    using result = proc_result<op##_result>; \
};

DECL_OP_TRAITS(create_task)
DECL_OP_TRAITS(get_tasks)
DECL_OP_TRAITS(fin_task)
DECL_OP_TRAITS(delay_task)
DECL_OP_TRAITS(alive)
DECL_OP_TRAITS(cleanup_active)
DECL_OP_TRAITS(cleanup_workers)
DECL_OP_TRAITS(wakeup_delayed)

#undef DECL_OP_TRAITS

}
