#pragma once

#include <ymod_xtasks/error.h>
#include <ymod_xtasks/types.h>
#include <ymod_xtasks/task.h>
#include <ymod_xtasks/results.h>
#include <vector>
#include <msgpack.hpp>

MSGPACK_ADD_ENUM(ymod_xtasks::err_code)

namespace ymod_xtasks {

struct lite_error
{

    lite_error(err_code err = err_code_no_error, const string& ext_reason = "")
    : code(err), ext_reason(ext_reason) { }

    /// true if error found.

    operator bool() const {
        return code != err_code_no_error;
    }

    err_code code;
    string ext_reason;

    MSGPACK_DEFINE(code, ext_reason)
};

/// Create error object from code and reason

inline lite_error make_lite_error(err_code err, const string& ext_reason = "") {
    return lite_error(err, ext_reason);
}

template <typename T>
struct proc_result
{
    ymod_xtasks::lite_error error;
    T data;

    MSGPACK_DEFINE(error, data)
};

}