#pragma once

#include <ctime>
#include <vector>
#include <boost/lexical_cast.hpp>
#include <boost/filesystem/path.hpp>
#include <ymod_xtasks/types.h>
#include "snapshot.h"

namespace ymod_xtasks {

using std::time_t;
using boost::lexical_cast;
using boost::filesystem::path;
#define SNAPSHOT_EXTENSION ".ss"
#define CHECKSUM_EXTENSION ".sum"

inline string gen_snapshot_filename(time_t timestamp)
{
    return lexical_cast<string>(timestamp) + SNAPSHOT_EXTENSION;
}

inline string gen_checksum_filename(time_t timestamp)
{
    return lexical_cast<string>(timestamp) + CHECKSUM_EXTENSION;
}

class SnapshotFilesInfo
{
public:
    SnapshotFilesInfo(const path& dir, const time_t timestamp)
    : timestamp_(timestamp)
    , dir_(dir)
    , snapshot_path_(dir_.native() + "/" + lexical_cast<string>(timestamp) + SNAPSHOT_EXTENSION)
    , sum_path_(dir_.native() + "/" + lexical_cast<string>(timestamp) + CHECKSUM_EXTENSION)
    {}

    const path& snapshot_filename() const
    {
        return snapshot_path_;
    }

    const path& checksum_filename() const
    {
        return sum_path_;
    }

    friend bool operator< (const SnapshotFilesInfo& info1, const SnapshotFilesInfo& info2);
private:
    time_t timestamp_;
    path dir_;
    path snapshot_path_;
    path sum_path_;
};

inline bool operator< (const SnapshotFilesInfo& info1, const SnapshotFilesInfo& info2)
{
    return info1.timestamp_ < info2.timestamp_;
}

void write_snapshot(const Snapshot& snapshot, const SnapshotFilesInfo& files_info);

Snapshot read_snapshot(const SnapshotFilesInfo& files_info);

typedef std::vector<SnapshotFilesInfo> SnapshotList;

SnapshotList list_snapshots(const path& dir);

}
