#pragma once

#include "snapshot.h"
#include <yxiva/core/json.h>

namespace ymod_xtasks
{

using yxiva::json_type;
using yxiva::json_value;
using yxiva::json_value_ref;

inline void task_to_json(const task& task, json_value_ref& out)
{
  out["id"] = task.id;
  out["uid"] = task.uid;
  out["service"] = task.service;
  out["local_id"] = task.local_id;
}

inline json_value snapshot_data_to_json(data_ptr data)
{
  json_value json;
  json_value pending(json_type::tarray);
  json_value active(json_type::tarray);
  json_value delayed(json_type::tarray);
  for (auto itask = data->tasks.begin();
      itask != data->tasks.end(); ++itask) {
    json_value item;
    const task_pack & task_meta = itask->second;
    task_to_json(task_meta.task(), item);
    item["wakeup_on_create"] = task_meta.wakeup_on_create();
    item["ignore_delay_if_pending"] = task_meta.ignore_delay_if_pending();

    if (task_meta.is_pending()) {
      auto item_copy = item;
      pending.push_back(item_copy);
    }
    if (task_meta.is_active()) {
      auto start_time = boost::posix_time::from_time_t(task_meta.active_start_time());
      item["worker"] = task_meta.worker();
      item["start_time"] = boost::posix_time::to_simple_string(start_time);
      active.push_back(item);
    }
    if (task_meta.is_delayed()) {
      auto start_time = boost::posix_time::from_time_t(task_meta.delay_start_time());
      item["start_time"] = boost::posix_time::to_simple_string(start_time);
      item["delay_sec"] = task_meta.delay_sec();
      delayed.push_back(item);
    }
  }
  json_value workers(json_type::tarray);
  for (auto cur = data->workers.begin();
      cur != data->workers.end(); ++cur) {
    json_value item;
    item["worker"] = cur->second.worker;
    item["active_tasks"] = cur->second.active_tasks;
    auto start_time = boost::posix_time::from_time_t(cur->second.last_seen);
    item["last_seen"] = boost::posix_time::to_simple_string(start_time);
    workers.push_back(item);
  }
  json["pending"] = pending;
  json["active"] = active;
  json["delayed"] = delayed;
  json["workers"] = workers;
  json["revision"] = data->rev;

  return json;
}

}