#pragma once

#include "messages.h"
#include "snapshot_io.h"
#include "data_processor.h"
#include <ymod_xtasks/types.h>
#include <ymod_paxos/db.h>

namespace ymod_xtasks {

class sync_manager : public ymod_paxos::sync_manager
{
public:
    sync_manager(const Snapshot& snapshot)
      : snapshot_(snapshot)
    {
    }

    boost::optional<serialized_data_type> make_delta_request()
    {
        return boost::optional<serialized_data_type>();
    }

    void apply_delta(const serialized_data_type&)
    {
    }

    size_t remained() const
    {
        return 0;
    }

    bool finished() const
    {
        return true;
    }

    Snapshot snapshot_;
};

}
