#!/usr/bin/env python3

import argparse

from mail.yasm.lib.gen import gen
from mail.yasm.lib.show import show


def main():
    parser = argparse.ArgumentParser(description="Generate YaSM panels & alerts")
    parser.add_argument(
        "-p", "--projects",
        nargs="+",
        help="List of projects to regenerate checks",
        required=True
    )
    parser.add_argument(
        "-o", "--owners",
        nargs="+",
        help="Panel owner name",
        required=True
    )
    parser.add_argument(
        "-s", "--show",
        help="Output templates into stdout",
        required=False,
        action='store_true'
    )
    args = parser.parse_args()

    if args.show:
        show(args.projects)
    else:
        gen(args.projects, args.owners)


if __name__ == "__main__":
    main()
