class FlapsConfig:
    def __init__(self, crit, stable):
        self.crit = crit
        self.stable = stable

    def to_jinja_dict(self):
        return {
            'critical': self.crit,
            'stable': self.stable
        }


class PhoneEscalation:
    def __init__(self, repeat, call_tries):
        self.repeat = repeat
        self.call_tries = call_tries

    def to_jinja_dict(self, responsibles):
        return {
            'template_name': 'phone_escalation',
            'template_kwargs': {
                'logins': responsibles,
                'repeat': self.repeat,
                'call_tries': self.call_tries,
            }
        }


class JugglerConfig:
    def __init__(self, notification_methods=None, flaps_config=None, phone_escalation=None, ignore_weekends=True,
                 namespace='mail.maildev', tags=None):
        self.notification_methods = notification_methods
        self.ignore_weekends = ignore_weekends
        self.flaps_config = flaps_config
        self.phone_escalation = phone_escalation
        self.namespace = namespace
        self.tags = tags or []

    def to_jinja_dict(self, responsibles):
        config = {
            'namespace': self.namespace,
            'tags': self.tags,
        }
        if self.flaps_config:
            config['flaps'] = self.flaps_config.to_jinja_dict()
        notifies = []
        if self.notification_methods:
            assert responsibles, "Can't set notification methods {} with no responsibles".format(self.notification_methods)
            notifies += [
                {
                    'template_name': 'on_status_change',
                    'template_kwargs': {
                        'status': [
                            {'from': 'OK', 'to': 'CRIT'},
                            {'from': 'CRIT', 'to': 'OK'},
                            {'from': 'WARN', 'to': 'CRIT'},
                            {'from': 'CRIT', 'to': 'WARN'},
                        ],
                        'login': responsibles[0:1],
                        'method': self.notification_methods,
                        'ignore_weekends': self.ignore_weekends
                    }
                }
            ]
        if self.phone_escalation:
            assert responsibles, "Can't set escalation with no responsibles"
            notifies += [self.phone_escalation.to_jinja_dict(responsibles)]
        if notifies:
            config['notifications'] = notifies
        return config


class AlertRanges:
    def __init__(self, warn, crit):
        self.warn = warn
        self.crit = crit

    def to_jinja_dict(self):
        return self.__dict__
