PRIMARY_ALERT_TEMPLATE = '''
[
    <% set juggler_without_calls = {
        "flaps": {
            "critical": 60,
            "stable": 30
        },
        "namespace": "mail.maildev"
    } %>
    <% set juggler_dict_without_calls = {
        "testing": juggler_without_calls,
        "prestable": juggler_without_calls,
        "production": juggler_without_calls,
    } %>


    <% set perc_alert_pattern = "perc(%s, or(%s, 1))"%>
    <% set mgroups = ["QLOUD"] %>


    <% for env in ["testing", "production", "prestable"] %>
        <% set alert_name = "%s_nginx_5xx" | format(env) %>
        <% set signal = perc_alert_pattern | format(
            "unistat-nginx_request_5xx_count_deee",
            "unistat-nginx_request_total_count_deee") %>
        <% set q_prj = "mail.barbet." ~ env %>
        <% set tags= { "itype":"qloud", "prj": q_prj } %>

        << Alert(
                name=alert_name,
                signal=signal,
                tags=tags,
                mgroups=mgroups,
                warn=[1, 2],
                crit=[2, None],
                juggler_check=juggler_dict_without_calls[env]|merge_with_dict({
                    "host": q_prj,
                    "service": alert_name
                })
        ) >>,

        <% for task in ["fill_backup", "fill_restore"] %>
        <% if task != 'unknown' %>
            <% set alert_name = "%s_task_%s_fails" | format(env, task) %>
            <% set signal = perc_alert_pattern | format(
                "unistat-fail_summ",
                "sum(unistat-success_summ, unistat-failed_summ)") %>
            << Alert(
                name=alert_name,
                signal=signal,
                tags=tags|merge_with_dict({"ctype": task}),
                mgroups=mgroups,
                warn=[1, 2],
                crit=[2, None],
                value_modify = {
                    "type": "summ",
                    "window": 60
                },
                juggler_check=juggler_dict_without_calls[env]|merge_with_dict({
                    "host": q_prj,
                    "service": alert_name
                })
            ) >>,
        <% endif %>
        <% endfor %>

    <% endfor %>
]
'''


def primary_template():
    return 'barbet', PRIMARY_ALERT_TEMPLATE
