from .macros import MACROS


def primary_alerts_template():
    return MACROS() + '''
    <# Resources #>
    << resources_alerts("yt") >>

    <# Cron Tasks #>
    << cron_day_alerts("yt") >>

    <# EWS Alerts #>
    << ews_alerts("yt") >>

    <# Nginx Codes Alerts #>
    << nginx_alerts("yt") >>

    <# Failed jobs Alerts #>
    << failed_jobs("yt", {"sendMail": [1, 3000],
                          "send_single_mail": [10, 100],
                          "ewsExportResourceMeetings": [1, 10],
                          "updateLayersTimestamps": [1, 200],
                          "handleMailAttach": [1, 3000]}) >>

    <# Web routes Alerts #>
    << web_routes_alerts("yt") >>

    <# Caldav routes Alerts #>
    << caldav_routes_alerts("yt") >>

    <# JDBC error requests #>
    << jdbc_requests_alerts("yt") >>

    <# Xiva 4xx/5xx answers #>
    << service_alerts("yt", "xiva", ["web", "caldav", "worker"]) >>

    <# Mail settings 4xx/5xx answers #>
    << service_alerts("yt", "mail-settings", ["web", "caldav", "worker"], true, {"/update_profile": [1, 5]}) >>

    <# Abook 4xx/5xx answers by route#>
    << service_alerts("yt", "abook", ["web", "caldav", "worker"], true, {"/carddav/1/report/addressbook-multiget": [5, 50]}) >>

    <# Collie 4xx/5xx answers by route#>
    << service_alerts("yt", "collie", ["web", "caldav", "worker"], true, {"/carddav/multiget": [5, 50]}) >>

    <# Staff 4xx/5xx answers by route#>
    << service_alerts("yt", "staff", ["web", "caldav", "worker"], true) >>

    <# BlackBox 4xx/5xx answers by route#>
    << service_alerts("yt", "blackbox", ["web", "caldav", "worker"], true) >>

    <# Yamb 4xx/5xx answers by route#>
    << service_alerts("yt", "yamb", ["worker"], true) >>

    <# Sms 4xx/5xx answers by route#>
    << service_alerts("yt", "sms", ["worker"], true) >>

    <# MulcaGate 4xx/5xx answers by route#>
    << service_alerts("yt", "mulcagate", ["worker"], true) >>

    <# AvatarManager 4xx/5xx answers by route#>
    << service_alerts("yt", "avatar_manager", ["caldav"], true) >>

    <# MailAttachLogListener parse errors #>
    << mail_attach_log_listener("yt") >>

    <# Zora alerts #>
    << zora_alerts("yt", "worker", "unistat-application_zora_request_deee", 100, 150, "ZoraRequestPerMinute") >>
    << zora_alerts("yt", "worker", "unistat-application_zora_request_quota_deee", 1, 3, "ZoraQuotaPerMinute") >>
    << zora_alerts("yt", "web", "unistat-application_zora_request_deee", 100, 150, "ZoraRequestPerMinute") >>
    << zora_alerts("yt", "web", "unistat-application_zora_request_quota_deee", 1, 3, "ZoraQuotaPerMinute") >>

    <# SO checkform error alerts #>
    << so_checkform_alerts("yt", "web", 1, None, "SoCheckformErrors") >>
    << so_checkform_alerts("yt", "worker", 1, None, "SoCheckformErrors") >>
    << so_checkform_alerts("yt", "caldav", 1, None, "SoCheckformErrors") >>
]'''


def primary_template():
    return 'Calendar-YT-alerts', primary_alerts_template()
