def MACROS():
    return '''
[
<% set base = {
    "mgroups": ["QLOUD"],
    "name_tmpl": "{prj}_{signal}"
} %>
<% set juggler_test = {
    "flaps": {
        "critical": 180,
        "stable": 30
    },
    "namespace": "mail.calendar",
    "tags": ["env_testing"]
} %>
<% set juggler_prod = {
    "flaps": {
        "critical": 300,
        "stable": 120
    },
    "namespace": "mail.calendar",
    "tags": ["env_production", "marty"],
} %>
<% set juggler_dict = {
    "testing": juggler_test,
    "prestable": juggler_prod,
    "production": juggler_prod,
} %>

<% macro create_alert(name, signals, tier, q_prj, env, warn, crit, type, window, is_disaster = False) %>
<% if tier != "" %>
    <% set final_name = env ~ "." ~ tier ~ "." ~ name %>
<% else %>
    <% set final_name = env ~ "." ~ name %>
<% endif %>
<% set alert_base = {
    "name": final_name,
    "disaster": is_disaster,
    "signal": signals,
    "tags": {
        "tier": tier ~ "*",
        "itype": "qloud",
        "prj": q_prj,
    },
    "mgroups": ["QLOUD"],
    "warn": warn,
    "crit": crit,
    "juggler_check":juggler_dict[env]|merge_with_dict({
        "host": q_prj,
        "service": tier ~ "." ~ name,
    }),

} %>

<% if window is defined %>
<% set alert_base = alert_base | merge_with_dict({"value_modify": {
        "type": type,
        "window": window,
    }}) %>
<% endif %>

<< Alert(base=alert_base) >>,
<% endmacro %>

<% macro resources_alerts(public_or_yt) %>
<% set signal_cpu = 'perc(portoinst-cpu_usage_cores_txxx, portoinst-cpu_guarantee_cores_txxx)' %>
<% set signal_unispace = 'perc(unistat-auto_disk_ephemeral_usage_bytes_axxx, unistat-auto_disk_ephemeral_total_bytes_axxx)' %>

<% for env, signals, tier, name, warn, crit in [
    ("testing", signal_unispace, "web", "max_unispace_percent", [90, 95], [95, None]),
    ("testing", signal_unispace, "caldav", "max_unispace_percent", [90, 95], [95, None]),
    ("testing", signal_unispace, "worker", "max_unispace_percent", [90, 95], [95, None]),

    ("prestable", signal_unispace, "web", "max_unispace_percent", [70, 80], [80, None]),
    ("prestable", signal_unispace, "caldav", "max_unispace_percent", [70, 80], [80, None]),

    ("production", signal_unispace, "web", "max_unispace_percent", [70, 80], [80, None]),
    ("production", signal_unispace, "caldav", "max_unispace_percent", [70, 80], [80, None]),
    ("production", signal_unispace, "worker", "max_unispace_percent", [70, 80], [80, None]),

    ("testing", signal_cpu, "web", "max_cpu_usage_percent", [90, None], [None, None]),
    ("testing", signal_cpu, "caldav", "max_cpu_usage_percent", [90, None], [None, None]),
    ("testing", signal_cpu, "worker", "max_cpu_usage_percent", [90, None], [None, None]),

    ("prestable", signal_cpu, "web", "max_cpu_usage_percent", [80, None], [None, None]),
    ("prestable", signal_cpu, "caldav", "max_cpu_usage_percent", [80, None], [None, None]),

    ("production", signal_cpu, "web", "max_cpu_usage_percent", [80, None], [None, None]),
    ("production", signal_cpu, "caldav", "max_cpu_usage_percent", [80, None], [None, None]),
    ("production", signal_cpu, "worker", "max_cpu_usage_percent", [80, None], [None, None]),
] %>
    <% set q_prj = "mail.calendar-" ~ public_or_yt ~ "." ~ env %>
    << create_alert(name, signals, tier, q_prj, env, warn, crit) >>
<% endfor %>
<% endmacro %>

<% macro cron_day_alerts(public_or_yt) %>
<% for env, task_name, tier, alert_name, warn, crit in [
    ("production", "updateAbsencesFromStaff", "worker", "update_absences_from_staff", [85, 90], [None, 85]),
    ("production", "cleanEventsLog", "worker", "clean_events_log", [85, 90], [None, 85]),
    ("production", "cleanResourceReservations", "worker", "clean_resource_reservations", [85, 90], [None, 85]),
    ("production", "cleanResourceSchedule", "worker", "clean_resource_schedule", [85, 90], [None, 85]),
    ("production", "compareAllResources", "worker", "compare_all_resources", [85, 90], [None, 85]),
    ("production", "ewsAllSynch", "worker", "ews_all_synch", [85, 90], [None, 85]),
    ("production", "ewsDesyncMonitoring", "worker", "ews_desync_monitoring", [85, 90], [None, 85]),
    ("production", "ewsExportResourceMeetings", "worker", "ews_export_resource_meetings", [85, 90], [None, 85]),
    ("production", "ewsPull", "worker", "ews_pull", [85, 90], [None, 85]),
    ("production", "ewsResubscribe", "worker", "ews_resubscribe", [85, 90], [None, 85]),
    ("production", "ewsSynch", "worker", "ews_synch", [85, 90], [None, 85]),
    ("production", "recalculateAndSendNotifications", "worker", "recalculate_and_send_notifications", [85, 90], [None, 85]),
    ("production", "reportBrokenDisplays", "worker", "report_broken_displays", [85, 90], [None, 85]),
    ("production", "sendRepetitionConfirmationEmailsAndKillUnconfirmed", "worker", "send_repetition_confirmation_emails_and_kill_unconfirmed", [85, 90], [None, 85]),
    ("production", "sendSmsNotifications", "worker", "send_sms_notifications", [85, 90], [None, 85]),
    ("production", "staffSynchronizer", "worker", "staff_synchronizer", [85, 90], [None, 85]),
    ("production", "updateResourcesFromCenter", "worker", "update_resources_from_center", [85, 90], [None, 85]),
    ("production", "updateSettingsFromCenter", "worker", "update_settings_from_center", [85, 90], [None, 85])
] %>

    <% set q_prj = "mail.calendar-" ~ public_or_yt ~ "." ~ env %>
    <% set signals = "or(unistat-worker_cron_day_" ~ task_name ~ "_axxx, 0)"%>
    <% set name = alert_name ~ "_day_success"%>
    << create_alert(name, signals, tier, q_prj, env, warn, crit) >>
<% endfor %>
<% endmacro %>

<% macro ews_alerts(public_or_yt) %>
<% set ews_exceptions = 'or(unistat-application_exchange_exception_deee, 0)' %>
<% set ews_timeouts = 'or(unistat-application_exchange_timeout_deee, 0)' %>
<% set ews_non_existent_mailbox = 'or(unistat-application_exchange_non_existent_mailbox_deee, 0)' %>
<% set exchange_ping = 'or(unistat-application_exchange_ping_error_ammx, 0)' %>
<% set exchange_desyncs = 'or(unistat-application_exchange_desyncs_axxx, 0)' %>
<% set exchange_desyncs_task_not_found = 'or(unistat-application_exchange_desyncs_task_not_found_axxx, 0)' %>
<% set exchange_pull_expired = 'or(unistat-application_exchange_pull_expired_axxx, 0)' %>
<% set exchange_push_expired = 'or(unistat-application_exchange_push_expired_axxx, 0)' %>

<% for env, signals, tier, name, warn, crit in [
    ("testing", ews_exceptions, "web", "ews_exceptions", [1, None], [None, None]),
    ("testing", ews_exceptions, "caldav", "ews_exceptions", [1, None], [None, None]),
    ("testing", ews_exceptions, "worker", "ews_exceptions", [1, None], [None, None]),

    ("prestable", ews_exceptions, "web", "ews_exceptions", [None, None], [1, None]),
    ("prestable", ews_exceptions, "caldav", "ews_exceptions", [None, None], [1, None]),

    ("production", ews_exceptions, "web", "ews_exceptions", [5, 5], [5, None]),
    ("production", ews_exceptions, "caldav", "ews_exceptions", [5, 5], [5, None]),
    ("production", ews_exceptions, "worker", "ews_exceptions", [10, 10], [10, None]),

    ("testing", ews_timeouts, "web", "ews_timeouts", [1, None], [None, None]),
    ("testing", ews_timeouts, "caldav", "ews_timeouts", [1, None], [None, None]),
    ("testing", ews_timeouts, "worker", "ews_timeouts", [1, None], [None, None]),

    ("prestable", ews_timeouts, "web", "ews_timeouts", [5, 5], [5, None]),
    ("prestable", ews_timeouts, "caldav", "ews_timeouts", [5, 5], [5, None]),

    ("production", ews_timeouts, "web", "ews_timeouts", [5, 5], [5, None]),
    ("production", ews_timeouts, "caldav", "ews_timeouts", [5, 5], [5, None]),
    ("production", ews_timeouts, "worker", "ews_timeouts", [5, 5], [5, None]),

    ("testing", ews_non_existent_mailbox, "web", "ews_non_existent_mailbox", [1, None], [None, None]),
    ("testing", ews_non_existent_mailbox, "caldav", "ews_non_existent_mailbox", [1, None], [None, None]),
    ("testing", ews_non_existent_mailbox, "worker", "ews_non_existent_mailbox", [1, None], [None, None]),

    ("prestable", ews_non_existent_mailbox, "web", "ews_non_existent_mailbox", [1, None], [None, None]),
    ("prestable", ews_non_existent_mailbox, "caldav", "ews_non_existent_mailbox", [1, None], [None, None]),

    ("production", ews_non_existent_mailbox, "web", "ews_non_existent_mailbox", [1, None], [None, None]),
    ("production", ews_non_existent_mailbox, "caldav", "ews_non_existent_mailbox", [1, None], [None, None]),
    ("production", ews_non_existent_mailbox, "worker", "ews_non_existent_mailbox", [1, None], [None, None]),

    ("production", exchange_ping, "", "exchange_ping", [1, None], [None, None]),
    ("production", exchange_desyncs, "", "exchange_desyncs", [None, None], [1, None]),
    ("production", exchange_desyncs_task_not_found, "", "exchange_desyncs_task_not_found", [None, None], [1, None]),
    ("production", exchange_pull_expired, "", "exchange_pull_expired", [1, None], [None, None]),
    ("production", exchange_push_expired, "", "exchange_push_expired", [1, None], [None, None]),
] %>
    <% set q_prj = "mail.calendar-" ~ public_or_yt ~ "." ~ env %>
    << create_alert(name, signals, tier, q_prj, env, warn, crit) >>
<% endfor %>
<% endmacro %>


<% macro nginx_alerts(public_or_yt, disasters = {"web": ["nginx_5xx"], "caldav": ["nginx_5xx"]}) %>
<% set nginx_web_5xx = 'or(unistat-nginx_request_web_5xx_count_deee, 0)' %>
<% set nginx_web_4xx = 'or(unistat-nginx_request_web_4xx_count_deee, 0)' %>

<% set nginx_caldav_5xx = 'or(unistat-nginx_request_caldav_5xx_count_deee, 0)' %>
<% set nginx_caldav_4xx = 'or(unistat-nginx_request_caldav_4xx_count_deee, 0)' %>
<% set caldav_warn_5xx_count = 8 %>
<% set caldav_crit_5xx_count = 20 %>
<% set web_warn_5xx_count = 1 %>
<% set web_crit_5xx_count = 5 %>

<% set caldav_warn_4xx_count = 100 %>
<% set caldav_crit_4xx_count = None %>
<% set web_warn_4xx_count = 10 %>
<% set web_crit_4xx_count = None %>

<% for env, signals, tier, name, warn, crit in [
    ("testing", nginx_web_5xx, "web", "nginx_5xx", [web_warn_5xx_count, web_crit_5xx_count], [web_crit_5xx_count, None]),
    ("testing", nginx_caldav_5xx, "caldav", "nginx_5xx", [caldav_warn_5xx_count, caldav_crit_5xx_count], [caldav_crit_5xx_count, None]),
    ("prestable", nginx_web_5xx, "web", "nginx_5xx", [web_warn_5xx_count, web_crit_5xx_count], [web_crit_5xx_count, None]),
    ("prestable", nginx_caldav_5xx, "caldav", "nginx_5xx", [caldav_warn_5xx_count, caldav_crit_5xx_count], [caldav_crit_5xx_count, None]),
    ("production", nginx_web_5xx, "web", "nginx_5xx", [web_warn_5xx_count, web_crit_5xx_count], [web_crit_5xx_count, None]),
    ("production", nginx_caldav_5xx, "caldav", "nginx_5xx", [caldav_warn_5xx_count, caldav_crit_5xx_count], [caldav_crit_5xx_count, None]),


    ("testing", nginx_web_4xx, "web", "nginx_4xx", [web_warn_4xx_count, web_crit_4xx_count], [web_crit_4xx_count, None]),
    ("testing", nginx_caldav_4xx, "caldav", "nginx_4xx", [caldav_warn_4xx_count, caldav_crit_4xx_count], [caldav_crit_4xx_count, None]),
    ("prestable", nginx_web_4xx, "web", "nginx_4xx", [web_warn_4xx_count, web_crit_4xx_count], [web_crit_4xx_count, None]),
    ("prestable", nginx_caldav_4xx, "caldav", "nginx_4xx", [caldav_warn_4xx_count, caldav_crit_4xx_count], [caldav_crit_4xx_count, None]),
    ("production", nginx_web_4xx, "web", "nginx_4xx", [web_warn_4xx_count, web_crit_4xx_count], [web_crit_4xx_count, None]),
    ("production", nginx_caldav_4xx, "caldav", "nginx_4xx", [caldav_warn_4xx_count, caldav_crit_4xx_count], [caldav_crit_4xx_count, None]),
] %>
    <% set is_disaster = env == "production" and tier in disasters and name in disasters[tier] %>
    <% set q_prj = "mail.calendar-" ~ public_or_yt ~ "." ~ env %>
    << create_alert(name, signals, tier, q_prj, env, warn, crit, is_disaster=is_disaster) >>
<% endfor %>
<% endmacro %>


<% macro web_routes_alerts(public_or_yt, warn_crit_by_route_dict = {}) %>
<% set web_route_warn_error_perc = 5 %>
<% set web_route_crit_error_perc = 25 %>

<% for env in ["production"] %>
    <% set q_prj = "mail.calendar-" ~ public_or_yt ~ "." ~ env %>

    <% for route in list_signals(pattern='unistat-application_request_web_(?P<route>\/.*)_(success|error)_deee', itype='qloud', prj=q_prj).distinct('route') %>
        <% if route in warn_crit_by_route_dict %>
            <% set warn =  warn_crit_by_route_dict[route][0] %>
            <% set crit =  warn_crit_by_route_dict[route][1] %>
        <% else %>
            <% set warn = web_route_warn_error_perc %>
            <% set crit = web_route_crit_error_perc %>
        <% endif %>

        <% set err_signal = 'or(unistat-application_request_web_' ~ route ~ '_error_deee, 0)' %>
        <% set success_signal = 'or(unistat-application_request_web_' ~ route ~ '_success_deee, 1)' %>
        <% set total_signal = 'sum(' ~ err_signal ~ ', ' ~ success_signal ~ ')' %>
        <% set signal = 'mul(100, div(' ~ err_signal ~ ', ' ~ total_signal ~ '))' %>
        << create_alert(route, signal, "web", q_prj, env, [warn, crit], [crit, None], "aver", 120) >>
    <% endfor %>

    <% for route in list_signals(pattern='unistat-application_request_web_(?P<route>ui.*)_(success|error)_deee', itype='qloud', prj=q_prj).distinct('route') %>
        <% if route in warn_crit_by_route_dict %>
            <% set warn =  warn_crit_by_route_dict[route][0] %>
            <% set crit =  warn_crit_by_route_dict[route][1] %>
        <% else %>
            <% set warn = web_route_warn_error_perc %>
            <% set crit = web_route_crit_error_perc %>
        <% endif %>

        <% set err_signal = 'or(unistat-application_request_web_' ~ route ~ '_error_deee, 0)' %>
        <% set success_signal = 'or(unistat-application_request_web_' ~ route ~ '_success_deee, 1)' %>
        <% set total_signal = 'sum(' ~ err_signal ~ ', ' ~ success_signal ~ ')' %>
        <% set signal = 'mul(100, div(' ~ err_signal ~ ', ' ~ total_signal ~ '))' %>
        << create_alert(route, signal, "web", q_prj, env, [warn, crit], [crit, None], "aver", 120) >>
    <% endfor %>

    <% for route in list_signals(pattern='unistat-application_request_ews_hook_(?P<route>.*)_(success|error)_deee', itype='qloud', prj=q_prj).distinct('route') %>
        <% if route in warn_crit_by_route_dict %>
            <% set warn =  warn_crit_by_route_dict[route][0] %>
            <% set crit =  warn_crit_by_route_dict[route][1] %>
        <% else %>
            <% set warn = web_route_warn_error_perc %>
            <% set crit = web_route_crit_error_perc %>
        <% endif %>

        <% if route in warn_crit_by_route_dict %>
            <% set warn =  warn_crit_by_route_dict[route][0] %>
            <% set crit =  warn_crit_by_route_dict[route][1] %>
        <% else %>
            <% set warn = web_route_warn_error_perc %>
            <% set crit = web_route_crit_error_perc %>
        <% endif %>

        <% set err_signal = 'or(unistat-application_request_ews_hook_' ~ route ~ '_error_deee, 0)' %>
        <% set success_signal = 'or(unistat-application_request_ews_hook_' ~ route ~ '_success_deee, 1)' %>
        <% set total_signal = 'sum(' ~ err_signal ~ ', ' ~ success_signal ~ ')' %>
        <% set signal = 'mul(100, div(' ~ err_signal ~ ', ' ~ total_signal ~ '))' %>
        << create_alert(route, signal, "web", q_prj, env, [warn, crit], [crit, None], "aver", 120) >>
    <% endfor %>
<% endfor %>
<% endmacro %>

<% macro caldav_routes_alerts(public_or_yt, warn_crit_by_route_dict = {}) %>
<% set caldav_route_warn_500 = 5 %>
<% set caldav_route_crit_500 = 15 %>

<% for env in ["production"] %>
    <% set q_prj = "mail.calendar-" ~ public_or_yt ~ "." ~ env %>

    <% for route, signals in list_signals(pattern='unistat-application_request_caldav_(?P<route>.*)_(?P<code>\\d+)_deee', itype='qloud', prj=q_prj).group_by('route') %>
        <% set err_signal = 'or(unistat-application_request_caldav_' ~ host ~ '_500_deee, 0)' %>
        <% set success_signal = 'sum(unistat-application_request_caldav_' ~ host ~ '_200_deee, unistat-application_request_caldav_' ~ host ~ '_207_deee)' %>
        <% set total_signal = 'or(sum(' ~ err_signal ~ ', ' ~ success_signal ~ '), 1)' %>
        <% set signal = 'mul(100, div(' ~ err_signal ~ ', ' ~ total_signal ~ '))' %>

        <% if route in warn_crit_by_route_dict %>
            <% set warn =  warn_crit_by_route_dict[route][0] %>
            <% set crit =  warn_crit_by_route_dict[route][1] %>
        <% else %>
            <% set warn = caldav_route_warn_500 %>
            <% set crit = caldav_route_crit_500 %>
        <% endif %>

        << create_alert(route, signal, "caldav", q_prj, env, [warn, crit], [crit, None], "aver", 60) >>
    <% endfor %>
<% endfor %>
<% endmacro %>

<% macro failed_jobs(public_or_yt, warn_crit_by_job_dict = {}) %>
<% set warn = 1 %>
<% set crit = 2 %>

<% for env in ["testing", "production"] %>
    <% set q_prj = "mail.calendar-" ~ public_or_yt ~ "." ~ env %>
    <% for taskName, signals in list_signals(pattern='unistat-application_worker_(?P<taskName>.*)_(?P<status>(success|error|retry))_deee', itype='qloud', prj=q_prj).group_by('taskName') %>
        <% if taskName in warn_crit_by_job_dict %>
            <% set warn =  warn_crit_by_job_dict[taskName][0] %>
            <% set crit =  warn_crit_by_job_dict[taskName][1] %>
        <% endif %>

        << create_alert(taskName, 'or(unistat-application_worker_' ~ taskName ~ '_error_deee, 0)',
            "worker", q_prj, env, [warn, crit], [crit, None], "summ", 900) >>
    <% endfor %>
<% endfor %>

<% endmacro %>

<% macro zora_alerts(public_or_yt, tier, signal_name, warn, crit, alert_name) %>
    <% set q_prj = "mail.calendar-" ~ public_or_yt ~ ".production" %>
    <% set signal = 'or(' ~ signal_name ~ ', 0)' %>
    << create_alert(alert_name, signal, tier, q_prj, "production", [warn, crit], [crit, None], "summ", 60) >>
<% endmacro %>

<% macro so_checkform_alerts(public_or_yt, tier, warn, crit, alert_name) %>
    <% set q_prj = "mail.calendar-" ~ public_or_yt ~ ".production" %>
    <% set signal = 'or(unistat-application_so-checker_error_deee, 0)' %>
    << create_alert(alert_name, signal, tier, q_prj, "production", [warn, crit], [crit, None], "summ", 60) >>
<% endmacro %>

<% macro jdbc_requests_alerts(public_or_yt) %>
    <% set jdbc_requests_max_error_perc = 10 %>

    <% for host, signals in list_signals(pattern='unistat-application_jdbc_request_(?P<host>.*)_execute_(?P<status>.*)_deee', itype='qloud', prj=q_prj).group_by('host') %>
        <% for env, tier, warn, crit in [
            ("testing", "worker", [jdbc_requests_max_error_perc, jdbc_requests_max_error_perc], [jdbc_requests_max_error_perc, None]),
            ("testing", "web", [jdbc_requests_max_error_perc, jdbc_requests_max_error_perc], [jdbc_requests_max_error_perc, None]),
            ("testing", "caldav", [jdbc_requests_max_error_perc, jdbc_requests_max_error_perc], [jdbc_requests_max_error_perc, None]),

            ("prestable", "web", [jdbc_requests_max_error_perc, jdbc_requests_max_error_perc], [jdbc_requests_max_error_perc, None]),
            ("prestable", "caldav", [jdbc_requests_max_error_perc, jdbc_requests_max_error_perc], [jdbc_requests_max_error_perc, None]),

            ("production", "worker", [jdbc_requests_max_error_perc, jdbc_requests_max_error_perc], [jdbc_requests_max_error_perc, None]),
            ("production", "web", [jdbc_requests_max_error_perc, jdbc_requests_max_error_perc], [jdbc_requests_max_error_perc, None]),
            ("production", "caldav", [jdbc_requests_max_error_perc, jdbc_requests_max_error_perc], [jdbc_requests_max_error_perc, None]),
        ] %>
            <% set q_prj = "mail.calendar-" ~ public_or_yt ~ "." ~ env %>
            <% set err_signal = 'or(unistat-application_jdbc_request_' ~ host ~ '_execute_error_deee, 0)' %>
            <% set success_signal = 'or(unistat-application_jdbc_request_' ~ host ~ '_execute_success_deee, 1)' %>
            <% set total_signal = 'sum(' ~ err_signal ~ ', ' ~ success_signal ~ ')' %>
            <% set signal = 'mul(100, div(' ~ err_signal ~ ', ' ~ total_signal ~ '))' %>
            << create_alert(host ~ '.request.error_percent', signal, tier, q_prj, env, warn, crit, "aver", 30) >>
        <% endfor %>
    <% endfor %>
<% endmacro %>

<% macro service_alerts(public_or_yt, service_name, tiers, is_with_routes=false, warn_crit_by_route_dict = {}) %>
<% set warn = 3 %>
<% set crit = 5 %>

<% for env in ["testing", "prestable", "production"] %>
    <% for tier in tiers %>
        <% set q_prj = "mail.calendar-" ~ public_or_yt ~ "." ~ env %>

        <% if is_with_routes %>
            <% for route, signals in list_signals(pattern='unistat-application_request_' ~ service_name ~ '_(?P<route>.*)_(?P<code>\d+xx)_deee', itype='qloud', prj=q_prj).group_by('route') %>
            <% set signal5xx = 'or(unistat-application_request_' ~ service_name ~ '_' ~ route ~ '_5xx_deee, 0)' %>
            <% set signal4xx = 'or(unistat-application_request_' ~ service_name ~ '_' ~ route ~ '_4xx_deee, 0)' %>

            <% if route in warn_crit_by_route_dict %>
                <% set warn =  warn_crit_by_route_dict[route][0] %>
                <% set crit =  warn_crit_by_route_dict[route][1] %>
            <% endif %>

            << create_alert(service_name ~ "." ~ route ~ "_5xx", signal5xx, tier, q_prj, env, [warn, crit], [crit, None], "summ", 120) >>
            << create_alert(service_name ~ "." ~ route ~ "_4xx", signal4xx, tier, q_prj, env, [warn, crit], [crit, None], "summ", 120) >>
            <% endfor %>
        <% else %>
            <% set signal5xx = 'or(unistat-application_request_' ~ service ~ '_5xx_deee, 0)' %>
            << create_alert(service_name ~ '_5xx', signal5xx, tier, q_prj, env, [warn, crit], [crit, None], "summ", 120) >>

            <% set signal4xx = 'or(unistat-application_request_' ~ service ~ '_4xx_deee, 0)' %>
            << create_alert(service_name ~ '_4xx', signal4xx, tier, q_prj, env, [warn, crit], [crit, None], "summ", 120) >>
        <% endif %>
    <% endfor %>
<% endfor %>
<% endmacro %>

<% macro mail_attach_log_listener(public_or_yt) %>
    <% set parse_error_warn = 5 %>
    <% set parse_error_crit = 15 %>

    <% for env in ["testing", "prestable", "production"] %>
        <% set q_prj = "mail.calendar-" ~ public_or_yt ~ "." ~ env %>

        << create_alert("MailAttachLogListener.parse_error", 'or(unistat-application_mail_attach_log_listener_parse_error_deee, 0)',
            'web', q_prj, env, [parse_error_warn, parse_error_crit], [parse_error_crit, None], "summ", 900) >>
    <% endfor %>
<% endmacro %>
'''
