from .macros import MACROS
from .constants import CONSTANTS

PRIMARY_PANEL_TEMPLATE = '''<< suggest.clear() >>
<% set corp_or_public = "YT" %>
<< suggest.add_var("env") >>
<< suggest.add_var("application") >>
<< suggest.add_var("routes_path") >>

<< suggest.set_choice_list("env", ["testing", "prestable", "production"]) >>
<< suggest.set_choice_list("application", ["caldav", "worker", "web", "ews", "alerts", "web_routes", "caldav_routes"]) >>
<< suggest.set_choice_list("routes_path", ["/internal/", "/kiosk/", "/mailhook/", "/display/", "/api/", "/soap/", "ui", "/mailhook/", "/"]) >>

<% set q_prj = "mail.calendar-yt." ~ env%>
<% set app_tag = "itype=qloud;prj=" ~ q_prj ~ ";tier=" ~ application ~ "*" %>

<% if application == "ews" %>
    <% set app_tag = "itype=qloud;prj=" ~ q_prj ~ ";tier=*" %>
<% endif %>

<% if application == "web_routes" %>
    <% set app_tag = "itype=qloud;prj=" ~ q_prj ~ ";tier=web*" %>
<% endif %>

<% if application == "caldav_routes" %>
    <% set app_tag = "itype=qloud;prj=" ~ q_prj ~ ";tier=caldav*" %>
<% endif %>
''' + CONSTANTS + MACROS + '''
{
    "title": "Calendar-YT (<< env >>)",
    "type": "panel",
    "charts": [
        <% if application == 'web' %>
            <% set row = main_layout.sub('flow', columns=16, default_width=2) %>
            << web_api_graphics(row) >>
            << jdbc_conn_graphics(row) >>
            << jdbc_requests_with_timings(row) >>
            << xiva_graphics(row) >>
            << abook_graphics(row) >>
            << collie_graphics(row) >>
            << blackbox_graphics(row) >>
            << staff_graphics(row) >>
            << ml_graphics(row) >>
            << mail_attach_graphics(row) >>
            << exchange_graphics(row) >>
            << mail_settings_graphics(row) >>
            << so_checkform_graphics(row) >>
            << zora_graphics(row) >>
        <% endif %>

        <% if application == 'web_routes' %>
            <% set row = main_layout.sub('flow', columns=16, default_width=2) %>
            <% if routes_path == '/internal/' %>
                << print_web_routes('web', '\/internal\/.*', row) >>
            <% elif routes_path == "/kiosk/" %>
                << print_web_routes('web', '\/kiosk\/.*', row) >>
            <% elif routes_path == "/display/" %>
                << print_web_routes('web', '\/display\/.*', row) >>
            <% elif routes_path == "/api/" %>
                << print_web_routes('web', '\/api\/.*', row) >>
            <% elif routes_path == "/mailhook/" %>
                << print_web_routes('web', '\/mailhook\/.*', row) >>
            <% elif routes_path == "/soap/" %>
                << print_web_routes('ews_hook', '\/soap\/.*', row) >>
            <% elif routes_path == "ui" %>
                << print_web_routes('web', 'ui.*', row) >>
            <% elif routes_path == "/" %>
                << print_web_routes('web', '(\/[a-zA-Z-_]+)', row) >>
            <% endif %>
        <% endif %>

        <% if application == 'caldav' %>
            <% set row = main_layout.sub('flow', columns=16, default_width=2) %>
            << caldav_api_graphics(row) >>
            << jdbc_conn_graphics(row) >>
            << jdbc_requests_with_timings(row) >>
            << abook_graphics(row) >>
            << collie_graphics(row) >>
            << blackbox_graphics(row) >>
            << avatar_manager_graphics(row) >>
            << xiva_graphics(row) >>
            << staff_graphics(row) >>
            << exchange_graphics(row) >>
            << mail_settings_graphics(row) >>
            << so_checkform_graphics(row) >>
        <% endif %>

        <% if application == 'ews' %>
            <% set row = main_layout.sub('flow', columns=8, default_width=2) %>
            << ews_ping_desyncs_pull(row) >>
        <% endif %>

        <% if application == 'caldav_routes' %>
            <% set row = main_layout.sub('flow', columns=16, default_width=2) %>
            << print_caldav_routes(row) >>
        <% endif %>

        <# Worker graphics #>
        <% if application == 'worker' %>
            <% set row = main_layout.sub('flow', columns=16, default_width=2) %>
            << yamb_grapics(row) >>
            << abook_graphics(row) >>
            << collie_graphics(row) >>
            << mulcagate_graphics(row) >>
            << jdbc_conn_graphics(row) >>
            << jdbc_requests_with_timings(row) >>
            << blackbox_graphics(row) >>
            << sms_graphics(row) >>
            << xiva_graphics(row) >>
            << staff_graphics(row) >>
            << exchange_graphics(row) >>
            << mail_settings_graphics(row) >>
            << so_checkform_graphics(row) >>

            <% set row = main_layout.sub('flow', columns=16, default_width=2) %>
            << worker_tasks_graphics(row) >>
            << events_ews_synchronizer_graphics(row) >>
            << zora_graphics(row) >>
        <% endif %>

        <# Alerts #>
        <% if application == 'alerts' %>
            <% set row = main_layout.sub('flow', columns=16, default_width=2) %>
            << print_alerts("Calendar-YT-alerts.", row) >>
        <% endif %>
    ]
}'''


def primary_template():
    return 'Calendar-YT', PRIMARY_PANEL_TEMPLATE
