MACROS = '''
<% macro print_quants(signal_pattern) %>
<% set signals = list_signals(pattern=signal_pattern, itype='qloud', prj=q_prj) %>
<% for q in quants %>
{
    "title": "<< q >>",
    "tag": "<< app_tag >>",
    "host": "QLOUD",
    "name": "conv(quant(hmerge(<< signals | join(', ')>>), << q >>), G)",
    "color": "<< make_color(q, start=50, stop=99, scheme="gradient") >>"
},
<%- endfor %>
<% endmacro %>

<% macro print_requests(service) %>
<% for code, color in status_with_color %>
    <% for route, signals in list_signals(pattern='unistat-application_request_' ~ service ~ '_(?P<route>.*)_(?P<code>\\d+xx)_deee', itype='qloud', prj=q_prj).group_by('route') %>
    <% set signal = 'or(unistat-application_request_' ~ service ~ '_' ~ route ~ '_' ~ code ~ '_deee, 0)' %>
        {
            <% if code == "5xx" %>
                <% set pattern = "^Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ "." ~ application ~ "." ~ service ~ "." ~ route ~ "_5xx$" %>
                <% set alert = list_alerts(name_pattern=pattern, itype='qloud', prj=q_prj).get() %>
                <% if alert %>
                    "alertName": "<< alert >>",
                <% endif %>
            <% elif code == "4xx" %>
                <% set pattern = "^Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ "." ~ application ~ "." ~ service ~ "." ~ route ~ "_4xx$" %>
                <% set alert = list_alerts(name_pattern=pattern, itype='qloud', prj=q_prj).get() %>
                <% if alert %>
                    "alertName": "<< alert >>",
                <% endif %>
            <% endif %>
            "title": "<< route >> << code >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "<< signal >>",
            "color": "<< color >>"
        },
    <% endfor %>
<% endfor %>
<% endmacro %>

<% macro jdbc_conn_graphics(row) %>
<% for host, signals in list_signals(pattern='unistat-application_jdbc_(?P<host>.*)_(?P<type>.*)_conn_ammx', itype='qloud', prj=q_prj).group_by('host') %>
{
    "title": "Conn << host >>",
    "type": "graphic",
    "stacked": true,
    "signals": [
        <% for signal in signals %>
        {
            "title": "<< signal.sub('type') >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "<< signal >>",
            "color": "<< color_by_connection_type[signal.sub('type')] >>"
        },
        <%- endfor %>
    ],
    << row.coords() >>
},
<%- endfor %>
<% endmacro %>

<% macro jdbc_requests_with_timings(row) %>
<% for host, signals in list_signals(pattern='unistat-application_jdbc_request_(?P<host>.*)_execute_(?P<status>.*)_deee', itype='qloud', prj=q_prj).group_by('host') %>
{
    "title": "Req << host >>",
    "type": "graphic",
    "stacked": true,
    "signals": [
        <% for status, color in error_success_with_color %>
        {
            <% set signal = 'or(unistat-application_jdbc_request_' ~ host ~ '_execute_' ~ status ~ '_deee, 0)' %>
            <% set alert_name = "^Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ "." ~ application ~ "." ~ host ~ '.request.' ~ status ~ "$" %>
            <% set alert = list_alerts(name_pattern=alert_name, itype='qloud', prj=q_prj).get() %>
            <% if alert %>
                "alertName": "<< alert >>",
            <% endif %>
            "title": "<< status >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "<< signal >>",
            "color": "<< color >>"
        },
        <%- endfor %>
    ],
    << row.coords() >>
},
{
    "title": "Time << host >>",
    "type": "graphic",
    "signals": [
        << print_quants('unistat-application_jdbc_request_' ~ host ~ '_execute_time_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<%- endfor %>
<% endmacro %>

<% macro exchange_graphics(row) %>
{
    "title": "EWS Requests",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        <% for status, color in exception_timeout_statues %>
        {
            <% set alert = list_alerts(name_pattern="Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ "." ~ application ~ ".ews_" ~ status, itype='qloud', prj=q_prj).get() %>
            <% if alert %>
                "alertName": "<< alert >>",
            <% endif %>
            "title": "<< status >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "or(unistat-application_exchange_<< status >>_deee, 0)",
            "color": "<< color >>"
        },
        <%- endfor %>
    ],
    << row.coords() >>
},
{
    "title": "EWS Requests By Method",
    "type": "graphic",
    "stacked": false,
    "period": 300,
    "signals": [
        <% for signal in list_signals(pattern='unistat-application_exchange_(?P<method>.*)_success_deee', itype='qloud', prj=q_prj) %>
        {
            "title": "<< signal.sub('method') >> success call",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "or(<< signal >>, 0)",
            "color": "#2bc687"
        },
        <% endfor %>
    ],
    << row.coords() >>
},
{
    "title": "EWS Timings",
    "type": "graphic",
    "period": 300,
    "signals": [
        << print_quants('unistat-application_exchange_time_(.*)_success_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro xiva_graphics(row) %>
{
    "title": "Xiva Requests",
    "type": "graphic",
    "stacked": true,
    "signals": [
        <% for status, color in status_with_color %>
        {
            <% set alert = list_alerts(name_pattern="^Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ "." ~ application ~ ".xiva." ~ status ~ "$", itype='qloud', prj=q_prj).get() %>
            <% if alert %>
                "alertName": "<< alert >>",
            <% endif %>
            "title": "<< status >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "or(unistat-application_request_xiva_<< status >>_deee, 0)",
            "color": "<< color >>"
        },
        <%- endfor %>
    ],
    << row.coords() >>
},
{
    "title": "Xiva Timings",
    "type": "graphic",
    "signals": [
        << print_quants('unistat-application_request_time_xiva_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro yamb_grapics(row) %>
{
    "title": "Yamb Requests",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        << print_requests('yamb') >>
    ],
    << row.coords() >>
},
{
    "title": "Yamb Timings",
    "type": "graphic",
    "period": 300,
    "signals": [
        << print_quants('unistat-application_request_time_yamb_/bot/send-message/_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro abook_graphics(row) %>
{
    "title": "Abook Requests",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        << print_requests('abook') >>
    ],
    << row.coords() >>
},
{
    "title": "Abook Timings",
    "type": "graphic",
    "period": 300,
    "signals": [
        << print_quants('unistat-application_request_time_abook_(.*)_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro collie_graphics(row) %>
{
    "title": "Collie Requests",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        << print_requests('collie') >>
    ],
    << row.coords() >>
},
{
    "title": "Collie Timings",
    "type": "graphic",
    "period": 300,
    "signals": [
        << print_quants('unistat-application_request_time_collie_(.*)_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro blackbox_graphics(row) %>
{
    "title": "Blackbox Requests",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        << print_requests('blackbox') >>
    ],
    << row.coords() >>
},
{
    "title": "Blackbox Timings",
    "type": "graphic",
    "period": 300,
    "signals": [
        << print_quants('unistat-application_request_time_blackbox_(.*)_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro mulcagate_graphics(row) %>
{
    "title": "MulcaGate Requests",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        << print_requests('mulcagate') >>
    ],
    << row.coords() >>
},
{
    "title": "MulcaGate Timings",
    "type": "graphic",
    "period": 300,
    "signals": [
        << print_quants('unistat-application_request_time_mulcagate_/gate/get_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro mail_settings_graphics(row) %>
{
    "title": "Mail-settings Requests",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        << print_requests('mail-settings') >>
    ],
    << row.coords() >>
},
{
    "title": "Mail-settings Timings",
    "type": "graphic",
    "period": 300,
    "signals": [
        << print_quants('unistat-application_request_time_mail-settings_/update_profile_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro sms_graphics(row) %>
{
    "title": "Sms Requests",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        << print_requests('sms') >>
    ],
    << row.coords() >>
},
{
    "title": "Sms Timings",
    "type": "graphic",
    "period": 300,
    "signals": [
        << print_quants('unistat-application_request_time_sms_/sendsms_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro staff_graphics(row) %>
{
    "title": "Staff Requests",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        << print_requests('staff') >>
    ],
    << row.coords() >>
},
{
    "title": "Staff Timings",
    "type": "graphic",
    "period": 300,
    "signals": [
        << print_quants('unistat-application_request_time_staff_(.*)_buckets_dhhh') >>
     ],
     << row.coords() >>
},
{
    "title": "Staff Cache",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        <% for signal in list_signals(pattern='unistat-application_staff_cache_(?P<status>.*)_deee', itype='qloud', prj=q_prj) | reverse %>
        {
            "title": "<< signal.sub('status') >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "<< signal >>",
            "color": "<< color_by_cache_hit_miss[signal.sub('status')] >>"
        },
        <%- endfor %>
    ],
    << row.coords() >>
},
<% endmacro %>

<% macro zora_graphics(row) %>
{
    "title": "Zora Requests",
    "type": "graphic",
    "signals": [
        {
            "title": "sent",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "unistat-application_zora_request_deee",
            "color": "#2bc687"
        },
        {
            "title": "quota problem",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "unistat-application_zora_request_quota_deee",
            "color": "#fc2101"
        }
    ],
    << row.coords() >>
}
<% endmacro %>

<% macro ml_graphics(row) %>
{
    "title": "ML Requests",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        << print_requests('ml') >>
    ],
    << row.coords() >>
},
{
    "title": "ML Timings",
    "type": "graphic",
    "period": 300,
    "signals": [
        << print_quants('unistat-application_request_time_ml_/apiv2/calendar/listinfo_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro mail_attach_graphics(row) %>
{
    "title": "MailAttachLogListener Requests",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        <% for status, color in mail_attach_statuses_with_color %>
        {
            <% if status == "parse_error" %>
                <% set alert = list_alerts(name_pattern="^Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ "." ~ application ~ ".MailAttachLogListener.parse_error$", itype='qloud', prj=q_prj).get() %>
                <% if alert %>
                    "alertName": "<< alert >>",
                <% endif %>
            <% endif %>
            "title": "<< status >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "or(unistat-application_mail_attach_log_listener_<< status >>_deee, 0)",
            "color": "<< color >>"
        },
        <%- endfor %>
    ],
    << row.coords() >>
},
{
    "title": "MailAttachLogListener LAG",
    "type": "graphic",
    "period": 300,
    "signals": [
        << print_quants('unistat-application_mail_attach_log_listener_time_lag_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro avatar_manager_graphics(row) %>
{
    "title": "Avatar Manager Requests",
    "type": "graphic",
    "stacked": true,
    "period": 300,
    "signals": [
        << print_requests('avatar_manager') >>
    ],
    << row.coords() >>
},
{
    "title": "Avatar Manager Timings",
    "type": "graphic",
    "period": 300,
    "signals": [
        << print_quants('unistat-application_request_time_avatar_manager_(.*)_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro web_api_graphics(row) %>
{
    "title": "Requests(Nginx)",
    "type": "graphic",
    "stacked": true,
    "signals": [
        <% for status, color in status_with_color %>
        {
            <% if status == "5xx" %>
                <% set alert = list_alerts(name_pattern="Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ "." ~ application ~ ".nginx_" ~ status, itype='qloud', prj=q_prj).get() %>
                <% if alert %>
                    "alertName": "<< alert >>",
                <% endif %>
            <% endif %>
            "title": "<< status >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": 'or(unistat-nginx_request_web_<< status >>_count_deee, 0)',
            "color": "<< color >>"
        },
        <%- endfor %>
    ],
    << row.coords() >>
},
{
    "title": "Timings(Nginx)",
    "type": "graphic",
    "signals": [
        <% for q in quants %>
        {
            "title": "<< q >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "quant(unistat-nginx_request_time_web_hgram, << q >>)",
            "color": "<< make_color(q, start=50, stop=99, scheme="gradient") >>"
        },
        <%- endfor %>
     ],
     << row.coords() >>
},
{
    "title": "Requests(Application)",
    "type": "graphic",
    "stacked": true,
    "signals": [
        <% for status, color in error_success_with_color %>
        <% set signals=list_signals(pattern='unistat-application_request_(web|ews_hook)_(.*)_' ~ status ~ '_deee', itype='qloud', prj=q_prj) %>
        {
            "title": "<< status >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "sum(<< signals | join(', ') >>)",
            "color": "<< color >>"
        },
        <%- endfor %>
    ],
    << row.coords() >>
},
<% endmacro %>

<% macro caldav_api_graphics(row) %>
{
    "title": "Requests(Nginx)",
    "type": "graphic",
    "stacked": true,
    "signals": [
        <% for status, color in status_with_color %>
        {
            <% if status == "5xx" %>
                <% set alert = list_alerts(name_pattern="^Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ "." ~ application ~ ".nginx_" ~ status ~ "$", itype='qloud', prj=q_prj).get() %>
                <% if alert %>
                    "alertName": "<< alert >>",
                <% endif %>
            <% endif %>
            "title": "<< status >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "unistat-nginx_request_caldav_<< status >>_count_deee",
            "color": "<< color >>"
        },
        <%- endfor %>
    ],
    << row.coords() >>
},
{
    "title": "Timings(Nginx)",
    "type": "graphic",
    "signals": [
        <% set signals = list_signals(pattern='unistat-nginx_request_time_caldav_(.*)_hgram', itype='qloud', prj=q_prj) %>
        <% for q in quants %>
        {
            "title": "<< q >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "quant(hmerge( << signals | reject('equalto', 'unistat-nginx_request_time_caldav_ping_hgram') | join(', ')>>), << q >>)",
            "color": "<< make_color(q, start=50, stop=99, scheme="gradient") >>"
        },
        <%- endfor %>
     ],
     << row.coords() >>
},
{
    "title": "Requests(Application)",
    "type": "graphic",
    "stacked": true,
    "signals": [
        <% for status_prefix, color in code_prefix_with_color %>
        <% set signals =list_signals(pattern='unistat-application_request_caldav_(.*)_' ~ status_prefix ~ '(\\d+)_deee', itype='qloud', prj=q_prj) %>
        {
            "title": "<< status_prefix >>xx",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "sum(<< signals | join(', ')>>)",
            "color": "<< color >>"
        },
        <%- endfor %>
    ],
    << row.coords() >>
},
{
    "title": "Timings(Application)",
    "type": "graphic",
    "signals": [
        << print_quants('unistat-application_request_time_caldav_(.*)_buckets_dhhh') >>
     ],
     << row.coords() >>
},
<% endmacro %>

<% macro print_web_routes(type, regexp, row) %>
<% for route, signals in list_signals(pattern='unistat-application_request_' ~ type ~ '_(?P<route>' ~ regexp ~ ')_(success|error)_deee', itype='qloud', prj=q_prj).group_by('route') %>
{
    "title": "<< route >>",
    "type": "graphic",
    "stacked": true,
    "signals": [
        <% for status, color in error_success_with_color %>
        {
            <% if status == "error" %>
              <% set alert = list_alerts(name_pattern="^Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ ".web." ~ route ~ "$", itype='qloud', prj=q_prj).get() %>
              <% if alert %>
                  "alertName": "<< alert >>",
              <% endif %>
            <% endif %>
            "title": "<< route >> << status >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "or(unistat-application_request_<< type >>_<< route >>_<< status >>_deee, 0)",
            "color": "<< color >>"
        },
        <%- endfor %>
    ],
    << row.coords() >>
},
<%- endfor %>
<% endmacro %>

<% macro worker_tasks_graphics(row) %>
<% for taskName, signals in list_signals(pattern='unistat-application_worker_(?P<taskName>.*)_(?P<code>\\w+)_deee', itype='qloud', prj=q_prj).group_by('taskName') %>
{
    "title": "<< taskName >>",
    "type": "graphic",
    "period": << period_by_task_name[taskName]|default ('300')>>,
    "stacked": true,
    "signals": [
        <% for status in ["error", "retry", "success"] %>
            {
                <% set signal = 'or(unistat-application_worker_' ~ taskName ~ '_' ~ status ~ '_deee, 0)' %>
                <% if status == "error" %>
                    <% set alert = list_alerts(name_pattern="^Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ "." ~ application ~ "." ~ taskName ~ "$", itype='qloud', prj=q_prj).get() %>
                    <% if alert %>
                        "alertName": "<< alert >>",
                    <% endif %>
                <% endif %>
                "title": "<< status >>",
                "tag": "<< app_tag >>",
                "host": "QLOUD",
                "name": "<< signal >>",
                "color": "<< color_by_task_status.get(status) >>"
            },
        <%- endfor %>

    ],
    << row.coords() >>
},
    <% for signal in list_signals(pattern='unistat-application_worker_time_' ~ taskName ~ '_buckets_dhhh', itype='qloud', prj=q_prj) %>
    {
        "title": "<< taskName >> Time",
        "type": "graphic",
        "period": << period_by_task_name[taskName]|default ('300')>>,
        "signals": [
            <% for q in ["max"] %>
            {
                "title": "<< q >>",
                "tag": "<< app_tag >>",
                "host": "QLOUD",
                "name": "conv(quant(<< signal >>, << q >>), G)",
            },
            <%- endfor %>
        ],
        << row.coords() >>
    },
    <%- endfor %>
<%- endfor %>
<% endmacro %>

<% macro print_caldav_routes(row) %>
<% for route, signals in list_signals(pattern='unistat-application_request_caldav_(?P<route>.*)_(?P<code>\\d+)_deee', itype='qloud', prj=q_prj).group_by('route') %>
{
    "title": "<< route >>",
    "type": "graphic",
    "stacked": true,
    "signals": [
        <% for signal in signals|reverse %>
        {
            <% if signal.sub('code') == "500" %>
                <% set alert = list_alerts(name_pattern="Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ ".caldav." ~ route ~ ".500", itype='qloud', prj=q_prj).get() %>
                <% if alert %>
                    "alertName": "<< alert >>",
                <% endif %>
            <% endif %>

            "title": "<< route >> << signal.sub('code') >>",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "<< signal >>",
            "color": "<< color_by_code_prefix[signal.sub('code')[0]] >>"
        },
        <%- endfor %>
    ],
    << row.coords() >>
},
<%- endfor %>
<% endmacro %>

<% macro events_ews_synchronizer_graphics(row) %>
{
    "title": "Ews Events Synchronizer",
    "type": "graphic",
    "stacked": true,
    "signals": [
        <% for title, signalName, color in [
                ("Error", "error", "#ff0000"),
                ("Subscription Error", "subscription_error", "#ff0000"),
                ("Ignore", "ignore", "#f29c1b"),
                ("Processed Already Updated", "processed_already_updated", "#2bc687"),
                ("Processed", "processed", "#2bc687"),
                ("Processed Skipped", "processed_skipped", "#2bc687"),
                ("Processed Updated", "processed_updated", "#2bc687")
                ] %>
            {
                "title": "<< title >>",
                "tag": "<< app_tag >>",
                "host": "QLOUD",
                "name": "or(unistat-application_ewsEventsSynchronizer_<< signalName >>_deee, 0)",
                "color": "<< color >>"
            },
        <%- endfor %>
    ],
    << row.coords() >>
},
<% endmacro %>

<% macro so_checkform_graphics(row) %>
{
    "title": "SO checkform",
    "type": "graphic",
    "signals": [
        {
            "title": "Ham",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "unistat-application_so-checker_ham_deee",
            "color": "#2bc687"
        },
        {
            "title": "Spam",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "unistat-application_so-checker_spam_deee",
            "color": "#f29c1b"
        },
        {
            "title": "Error",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "unistat-application_so-checker_error_deee",
            "color": "#ff0000"
        }
    ],
    << row.coords() >>
},
<% endmacro %>

<% macro ews_ping_desyncs_pull(row) %>
{
    "title": "Ews Ping",
    "type": "graphic",
    "stacked": true,
    "signals": [
        <% for status, color in error_success_with_color %>
            {
                <% if status == "error" %>
                    <% set alert = list_alerts(name_pattern="^Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ ".exchange_ping$", itype='qloud', prj=q_prj).get() %>
                    <% if alert %>
                        "alertName": "<< alert >>",
                    <% endif %>
                <% endif %>
                "title": "<< status >>",
                "tag": "<< app_tag >>",
                "host": "QLOUD",
                "name": "or(unistat-application_exchange_ping_<< status >>_ammx, 0)",
                "color": "<< color >>"
            },
        <%- endfor %>
    ],
    << row.coords() >>
},
{
    "title": "Ews Desyncs",
    "type": "graphic",
    "stacked": true,
    "signals": [
        {
            <% set alert = list_alerts(name_pattern="^Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ ".exchange_desyncs$", itype='qloud', prj=q_prj).get() %>
            <% if alert %>
                "alertName": "<< alert >>",
            <% endif %>
            "title": "desyncs count",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "or(unistat-application_exchange_desyncs_axxx, 0)",
            "color": "#ff0000"
        },
        {
            <% set alert = list_alerts(name_pattern="^Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ ".exchange_desyncs_task_not_found$", itype='qloud', prj=q_prj).get() %>
            <% if alert %>
                "alertName": "<< alert >>",
            <% endif %>
            "title": "task not found",
            "tag": "<< app_tag >>",
            "host": "QLOUD",
            "name": "or(unistat-application_exchange_desyncs_task_not_found_axxx, 0)",
            "color": "#ff0000"
        },
    ],
    << row.coords() >>
},
{
    "title": "Pull/Push Expired",
    "type": "graphic",
    "stacked": true,
    "signals": [
        <% for type in ["pull", "push"] %>
            {
                <% set alert = list_alerts(name_pattern="^Calendar-" ~ corp_or_public ~ "-alerts." ~ env ~ ".exchange_" ~ type ~ "_expired$", itype='qloud', prj=q_prj).get() %>
                <% if alert %>
                    "alertName": "<< alert >>",
                <% endif %>
                "title": "<< type >>",
                "tag": "<< app_tag >>",
                "host": "QLOUD",
                "name": "or(unistat-application_exchange_<< type >>_expired_axxx, 0)",
                "color": "#ff0000"
            },
        <% endfor %>
    ],
    << row.coords() >>
}
<% endmacro %>

<% macro print_alerts(name_pattern, row) %>
<% for alert in list_alerts(name_pattern=name_pattern ~ env ~ "(.*)", itype='qloud', prj=q_prj) %>
    <% set alert = alert | string %>
    <% set app_name = alert.split('.')[2] %>
    <% set title = alert.split('.')[2:] | join('.') %>
    {
        "type": "alert",
        "name": "<< alert >>",
        "title": "<< title >>",
        << row.coords() >>
    },
<%- endfor %>
<% endmacro %>
'''
