from mail.yasm.lib.commondb import get_dbaas_alerts_template
from mail.yasm.lib.calendardb.constants import CLUSTERS
from mail.yasm.lib.micronaut.alert import JugglerConfig, FlapsConfig


def primary_template():  # noqa
    test_juggler_config = JugglerConfig(
        namespace='mail.calendar',
        flaps_config=FlapsConfig(crit=600, stable=120),
        tags=['env_testing'],
    )
    prod_juggler_config = JugglerConfig(
        namespace='mail.calendar',
        flaps_config=FlapsConfig(crit=300, stable=60),
        tags=['env_production'],
    )
    return (
        'Calendardb-dbaas-alerts',
        get_dbaas_alerts_template(
            name="calendardb",
            clusters=CLUSTERS,
            test_juggler_config=test_juggler_config,
            prod_juggler_config=prod_juggler_config
        )
    )
