from mail.yasm.lib.commondb import FIELD_ABC, FIELD_ESCALATION, FIELD_FOLDER, FIELD_ID
from mail.yasm.lib.commondb import JUGGLER_TEST, JUGGLER_PROD, ABC_CALBACK, ABC_CALCORPBACK

_FOLDER_ID = 'foo6r4c9qsqjppsja6nf'


def _get_cluster(cluster_id, escalation, abc):
    return {FIELD_ID: cluster_id, FIELD_ESCALATION: escalation, FIELD_ABC: abc, FIELD_FOLDER: _FOLDER_ID}


CLUSTERS = {
    "calcorpdb-test": _get_cluster("mdbsv4huordjbijcqtjf", JUGGLER_TEST, ABC_CALCORPBACK),
    "calcorpdb-prod": _get_cluster("mdbjk29393msftc2fb6c", JUGGLER_PROD, ABC_CALCORPBACK),
    "calendardb-test": _get_cluster("mdblrgkkhdfrmoo6mqmp", JUGGLER_TEST, ABC_CALBACK),
    "calendardb-prod": _get_cluster("mdb45fsjh7npi9jine6n", JUGGLER_PROD, ABC_CALBACK),
    "cerberus-test-public": _get_cluster("mdb6diuolop1hk47lvua", JUGGLER_TEST, ABC_CALBACK),
    "cerberus-test-corp": _get_cluster("mdblb41i2ls95dnahl0a", JUGGLER_TEST, ABC_CALCORPBACK)
}
