from mail.yasm.lib.commondb import get_dbaas_alerts_template, get_max_used_space_alert, get_cpu_usage_alert, get_query_75_percentile_ms_alert
from mail.yasm.lib.callmeback.constants import CLUSTERS
from mail.yasm.lib.micronaut.alert import JugglerConfig, FlapsConfig


def primary_alerts_template():
    test_juggler_config = JugglerConfig(
        namespace='mail.callmeback',
        flaps_config=FlapsConfig(crit=600, stable=120),
        tags=['env_testing'],
    )
    prod_juggler_config = JugglerConfig(
        namespace='mail.callmeback',
        flaps_config=FlapsConfig(crit=300, stable=60),
        tags=['env_production', 'any_time_calls'],
    )
    alerts = (
        get_max_used_space_alert(warn_perc=85, crit_perc=90)
        + get_cpu_usage_alert(warn_perc=80, crit_perc=90)
        + get_query_75_percentile_ms_alert(warn=30, crit=60)
    )
    return get_dbaas_alerts_template(
        name='callmebackdb',
        clusters=CLUSTERS,
        test_juggler_config=test_juggler_config,
        prod_juggler_config=prod_juggler_config,
        alerts=alerts,
    )


def primary_template():
    return 'Callmebackdb-alerts', primary_alerts_template()
