PRIMARY_ALERT_TEMPLATE = '''
[
<% set juggler_test = {
        "flaps": {
            "critical": 1500,
            "stable": 300
        },
        "namespace": "mail.callmeback",
        "tags": ["env_testing"],
    } %>
    <% set juggler_prod = {
        "flaps": {
            "critical": 1500,
            "stable": 300
        },
        "namespace": "mail.callmeback",
        "tags": ["env_production", "working_time_calls"],
    } %>
    <% set juggler_dict = {
        "test": juggler_test,
        "prod": juggler_prod,
    } %>

    <% for env in ["test"] %>
        <% set q_prj = "mail.callmeback." ~ env %>

        << Alert(
            name=env ~ ".lost_buckets",
            signal="unistat-db_lost_buckets_max",
            tags={
                "itype": "qloud",
                "prj": q_prj,
                "tier": "primary",
            },
            mgroups=["QLOUD"],
            warn=[1, 1],
            crit=[1, None],
            juggler_check=juggler_dict[env]|merge_with_dict({
                "host": q_prj,
                "service": "lost_buckets"
            })
        ) >> ,
        << TrendAlert(
            name=env ~ ".late_events",
            signal="unistat-db_late_events_max",
            tags={
                "itype": "qloud",
                "prj": q_prj,
                "tier": "primary",
            },
            mgroups=["QLOUD"],
            trend="up",
            interval=300,
            value_modify = {
                "type": "min",
                "window": 60
            },
            warn=[1, 2],
            crit=[2, None],
            juggler_check=juggler_dict[env]|merge_with_dict({
                "host": q_prj,
                "service": "late_events"
            })
        ) >> ,
    <% endfor %>
]
'''


def primary_template():
    return 'Callmebackdb-dbstats-alerts', PRIMARY_ALERT_TEMPLATE
