def primary_alerts_template():
    return '''[
    <% set base = {
        "mgroups": ["QLOUD"],
        "name_tmpl": "{prj}_{signal}"
    } %>
    <% set juggler_test = {
        "flaps": {
            "critical": 180,
            "stable": 30
        },
        "namespace": "mail.callmeback",
        "tags": ["env_testing"],
    } %>
    <% set juggler_prod = {
        "flaps": {
            "critical": 120,
            "stable": 15
        },
        "namespace": "mail.callmeback",
        "tags": ["env_production", "any_time_calls"],
    } %>
    <% set juggler_dict = {
        "test": juggler_test,
        "prod": juggler_prod,
    } %>

    <# API Errors #>
    <% for env, warn, crit in [
        ("test", [10, 50], [50, None]),
        ("prod", [2, 5], [5, None]),
    ] %>
    <% set q_prj = "mail.callmeback." ~ env %>
        <# Should add 'worker' later #>
        <% for http_component in ['api'] %>

        << Alert(
            base=base,
            signal="or(diff(100, perc(sum(push-response_2xx_summ, push-response_4xx_summ), push-requests_summ)), 0)",
            name_tmpl="{prj}_" ~ http_component ~ "_http_non_2xx_4xx_perc",
            tags={
                "itype": "qloudrouter",
                "prj": q_prj,
                "ctype": "callmeback-" ~ env,
                "tier": http_component ~ "-*",
            },
            warn=warn,
            crit=crit,
            juggler_check=juggler_dict[env]|merge_with_dict({
                "host": q_prj,
                "service": http_component ~ "-errors",
            })
        ) >> ,

        <% endfor %>
    <% endfor %>

    <# API Timings #>
    <% for env, warn, crit in [
        ("test", [1, 5], [5, None]),
        ("prod", [0.5, 2], [2, None]),
    ] %>
    <% set q_prj = "mail.callmeback." ~ env %>
        <# Should add 'worker' later #>
        <% for http_component in ['api'] %>
        <% set q = 99 %>

        << Alert(
            base=base,
            signal="or(quant(push-time_hgram, " ~ q ~ "), 0)",
            name_tmpl="{prj}_" ~ http_component ~ "_q" ~ q ~ "_timings",
            tags={
                "itype": "qloudrouter",
                "prj": q_prj,
                "ctype": "callmeback-" ~ env,
                "tier": http_component ~ "-*",
            },
            warn=warn,
            crit=crit,
            juggler_check=juggler_dict[env]|merge_with_dict({
                "host": q_prj,
                "service": http_component ~ "-timings"
            })
        ) >> ,

        <% endfor %>
    <% endfor %>
]'''


def primary_template():
    return 'Callmeback-alerts', primary_alerts_template()
