PRIMARY_PANEL_TEMPLATE = '''<< suggest.clear() >>
<< suggest.add_var("env") >>
<< suggest.set_choice_list("env", ["test", "prod"]) >>

<% set dbaas_cids = {"test": "482d6b0a-a096-4692-b5c8-4af1680064d2", "prod": "6a12b272-08ce-417d-a208-5ceac6293ba6"} %>
<% set cid = dbaas_cids[env] %>

<# Stolen from DBaaS panel #>
<% set cid_tags = 'ctype=' ~ cid %>
<% set dom0_tags = 'tier=primary,replica' %>
<% set domu_tags = 'tier=primary,replica' %>

<% set q_prj = "mail.callmeback." ~ env %>
<% set router_tag = "itype=qloudrouter;prj=" ~ q_prj ~ ";ctype=callmeback-" ~ env %>
<% set app_tag = "itype=qloud;prj=" ~ q_prj %>
<% set dbstats_tag = "tier=primary;" ~ app_tag %>

<% set main_layout = create_main_layout("vertical") %>

{
    "title": "CallMeBack (<< env >>)",
    "type": "panel",
    "charts": [
        <% set primary_layout = main_layout.sub('flow', default_height=1, columns=6) %>
        {
            "title": "API Requests & Errors",
            "type": "graphic",
            "normalize": true,
            "stacked": true,
            "minValue": 0,
            "signals": [
                {
                    "title": "2xx",
                    "tag": "<< router_tag >>;tier=api-*",
                    "host": "QLOUD",
                    "name": "push-response_2xx_summ",
                    "transforms": [{"name": "moving_avg"}],
                    "color": "#2bc687"
                },
                {
                    "title": "4xx",
                    "tag": "<< router_tag >>;tier=api-*",
                    "host": "QLOUD",
                    "name": "push-response_4xx_summ",
                    "transforms": [{"name": "moving_avg"}],
                    "color": "#ff5577"
                },
                {
                   "title": "5xx",
                   "tag": "<< router_tag >>;tier=api-*",
                   "host": "QLOUD",
                   "name": "push-response_5xx_summ",
                   "transforms": [{"name": "moving_avg"}],
                   "color": "#ccaa22"
                }
            ],
            << primary_layout.coords() >>
        },
        {
            "title": "API Timings",
             "type": "graphic",
             "minValue": 0,
             "signals": [
                 <% for q in [50, 80, 90, 95, 98, 99] %>
                 {
                     "title": "<< q >>",
                     "tag": "<< router_tag >>;tier=api-*",
                 "host": "QLOUD",
                 "name": "quant(push-time_hgram, << q >>)",
                 <% set alert = list_alerts(signal_pattern="quant(push-time_hgram, << q >>)").get() %>
                 <% if alert %>
                 "alertName": "<< alert >> ",
                 <% endif %>
                 "color": "<< make_color(q, start=50, stop=99, scheme="gradient") >>"
                },
                <%- endfor %>
             ],
             << primary_layout.coords() >>
        },
        {
            "title": "API CPU Usage",
            "type": "graphic",
            "stacked": true,
            "normalize": true,
            "yAxis": [
                {
                    "minValue": 0,
                    "maxValue": 24
                },
                {
                    "minValue": 0,
                    "maxValue": 24
                }
            ],
            "signals": [
                {
                    "tag": "<< app_tag >>;tier=api-*",
                    "host": "QLOUD",
                    "name": "portoinst-cpu_usage_cores_tmmv",
                    "title": "Used",
                    "yAxis": 0
                },
                {
                    "tag": "<< app_tag >>;tier=api-*",
                    "host": "QLOUD",
                    "name": "portoinst-cpu_guarantee_cores_tmmv",
                    "title": "Guaranteed",
                    "stacked": false,
                    "yAxis": 1
                },
                {
                    "tag": "<< app_tag >>;tier=api-*",
                    "host": "QLOUD",
                    "name": "portoinst-cpu_wait_cores_tmmv",
                    "title": "Wait",
                    "yAxis": 0
                }
            ],
            "links": [{
                "title": "Qloud panel",
                "url": "https://platform.yandex-team.ru/projects/mail/callmeback/<< env >>?panel=resources&tiers=api%7C*&tab=dashboard"
            }],
            << primary_layout.coords() >>
        },
        {"title": "Worker callback status",
         "type": "graphic",
         "normalize": true,
         "stacked": true,
         "minValue": 0,
         "signals": [
             {"title": "ok",
              "tag": "<< app_tag >>",
              "host": "QLOUD",
              "transforms": [{"name": "moving_avg"}],
              "name": "sum(<% set signals = list_signals(pattern='unistat-callback_(?P<target>\\S+)_oks_summ', itype='qloud', prj=q_prj) %> << signals | join(', ')>>)",
              "color": "#2bc687"
             },
             {"title": "fail",
              "tag": "<< app_tag >>",
              "host": "QLOUD",
              "transforms": [{"name": "moving_avg"}],
              "name": "sum(<% set signals = list_signals(pattern='unistat-callback_(?P<target>\\S+)_fails_summ', itype='qloud', prj=q_prj) %> << signals | join(', ')>>)",
              "color": "#ff5577"
             },
             {"title": "timeout",
              "tag": "<< app_tag >>",
              "host": "QLOUD",
              "transforms": [{"name": "moving_avg"}],
              "name": "sum(<% set signals = list_signals(pattern='unistat-callback_(?P<target>\\S+)_timeouts_summ', itype='qloud', prj=q_prj) %> << signals | join(', ')>>)",
              "color": "#ccaa22"
             }
         ],
         << primary_layout.coords() >>
        },
        {"title": "Worker pending events",
         "type": "graphic",
         "minValue": 0,
         "signals": [
            {"title": "Queued events",
             "tag": "<< app_tag >>",
             "host": "QLOUD",
             "name": "unistat-CallbackHerald_queued_qsize_ammx"
            },
            {"title": "Delayed events",
             "tag": "<< app_tag >>",
             "host": "QLOUD",
             "name": "unistat-CallbackHerald_delayed_qsize_ammx"
            }
         ],
         << primary_layout.coords() >>
        },
        {
            "title": "Worker CPU Usage",
            "type": "graphic",
            "stacked": true,
            "normalize": true,
            "yAxis": [
                {
                    "minValue": 0,
                    "maxValue": 24
                },
                {
                    "minValue": 0,
                    "maxValue": 24
                }
            ],
            "signals": [
                {
                    "tag": "<< app_tag >>;tier=worker-*",
                    "host": "QLOUD",
                    "name": "portoinst-cpu_usage_cores_tmmv",
                    "title": "Used",
                    "yAxis": 0
                },
                {
                    "tag": "<< app_tag >>;tier=worker-*",
                    "host": "QLOUD",
                    "name": "portoinst-cpu_guarantee_cores_tmmv",
                    "title": "Guaranteed",
                    "stacked": false,
                    "yAxis": 1
                },
                {
                    "tag": "<< app_tag >>;tier=worker-*",
                    "host": "QLOUD",
                    "name": "portoinst-cpu_wait_cores_tmmv",
                    "title": "Wait",
                    "yAxis": 0
                }
            ],
            "links": [{
                "title": "Qloud panel",
                "url": "https://platform.yandex-team.ru/projects/mail/callmeback/<< env >>?panel=resources&tiers=worker%7C*&tab=dashboard"
            }],
            << primary_layout.coords() >>
        },
        {
            "title": "Lost buckets",
            "type": "graphic",
            "minValue": 0,
            "signals": [
                {
                    "title": "Lost buckets",
                    "tag": "<< dbstats_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-db_lost_buckets_max",
                    "alertName": "Callmeback-alerts.<< q_prj >>_unistat-db_lost_buckets_max"
                }
            ],
            << primary_layout.coords() >>
        },
        {
            "title": "Late events",
            "type": "graphic",
            "minValue": 0,
            "signals": [
                {
                    "title": "Late events",
                    "tag": "<< dbstats_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-db_late_events_max"
                }
             ],
             << primary_layout.coords(width=1) >>
        },
        {
            "title": "Pending events",
            "type": "graphic",
            "minValue": 0,
            "signals": [
                {
                    "title": "pending events",
                    "tag": "<< dbstats_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-db_pending_events_max"
                }
             ],
             << primary_layout.coords(width=1) >>
        },
        {
            "title": "DB CPU Usage",
            "type": "graphic",
            "stacked": true,
            "normalize": true,
            "yAxis": [
                {
                    "minValue": 0,
                    "maxValue": 12
                },
                {
                    "minValue": 0,
                    "maxValue": 12
                }
            ],
            "signals": [
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_usage_cores_tmmv",
                    "title": "Used",
                    "yAxis": 0
                },
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_guarantee_cores_tmmv",
                    "title": "Guaranteed",
                    "stacked": false,
                    "yAxis": 1
                },
                {
                    "tag": "itype=mdbdom0;<< cid_tags >>;<< dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_wait_cores_tmmv",
                    "title": "Wait",
                    "yAxis": 0
                }
            ],
            "links": [{
                "title": "DBaaS panel",
                "url": "https://yasm.yandex-team.ru/template/panel/dbaas_postgres_metrics/cid=<< cid >>"
            }],
            << primary_layout.coords() >>
        },
        {
            "type": "text",
            "text": "Per-target statistics",
            << main_layout.coords(width=6, height=0.5) >>
        },
        <% set per_target_layout = main_layout.sub('flow', default_width=1, default_height=1, columns=6)%>
        <% for target in list_signals(pattern='unistat-callback_(?P<target>\\S+)_(?P<kind>\\S+)_summ', itype='qloud', prj=q_prj).distinct('target') %>
        {
            "title": "<< target >>",
            "type": "graphic",
            "normalize": true,
            "stacked": true,
            "minValue": 0,
            "signals": [
                {"tag": "<< app_tag >>", "host": "QLOUD", "transforms": [{"name": "moving_avg"}], "name": "unistat-callback_<< target >>_oks_summ", "title": "ok", "color": "#2bc687"},
                {"tag": "<< app_tag >>", "host": "QLOUD", "transforms": [{"name": "moving_avg"}], "name": "unistat-callback_<< target >>_fails_summ", "title": "fail", "color": "#ff5577"},
                {"tag": "<< app_tag >>", "host": "QLOUD", "transforms": [{"name": "moving_avg"}], "name": "unistat-callback_<< target >>_timeouts_summ", "title": "timeout", "color": "#ccaa22"}
            ],
            << per_target_layout.coords() >>
        },
        <%- endfor %>
    ]
}'''


def primary_template():
    return 'Callmeback', PRIMARY_PANEL_TEMPLATE
