from mail.yasm.lib.cerberus.panels.cerberus import CONFIGURATIONS, ENVIRONMENTS
from mail.yasm.lib.micronaut.alert import generate_alerts, AlertConfiguration, AlertRanges, JugglerConfig, \
    FlapsConfig, ExtraAlert


PARTMAN_MAINTENANCE_ALERT = ExtraAlert(name='task_partman-maintenance',
                                       signal='or(unistat-task_partman_maintenance_error_axxx, 0)',
                                       alert_ranges=AlertRanges(
                                           warn=[1, None],
                                           crit=[None, None]
                                       ))

EXTRA_ALERTS = {
    'public': {
        'worker': [
            PARTMAN_MAINTENANCE_ALERT
        ]
    },
    'yt': {
        'worker': [
            PARTMAN_MAINTENANCE_ALERT,
            ExtraAlert(name='task_sync-staff',
                       signal='or(unistat-task_sync_staff_error_axxx, 0)',
                       alert_ranges=AlertRanges(
                           warn=[1, None],
                           crit=[None, None]
                       ))
        ]
    }
}


def alerts_templates():
    for c in CONFIGURATIONS:
        qloud_project_id = 'mail.cerberus-' + c.domain

        for env in ENVIRONMENTS:
            is_prod = env == 'production'

            juggler_config = JugglerConfig(
                namespace='mail.cerberus',
                flaps_config=FlapsConfig(crit=120, stable=15) if is_prod else FlapsConfig(crit=180, stable=30),
                tags=['env_production'] if is_prod else ['env_testing'],
            )

            alert_config = AlertConfiguration(
                controllers_4xx_alert_ranges=AlertRanges(warn=[1, None], crit=[None, None]),
                controllers_5xx_alert_ranges=AlertRanges(warn=[1, 15], crit=[15, None]),
                clients_4xx_alert_ranges=AlertRanges(warn=[1, 100], crit=[100, None]),
                clients_5xx_alert_ranges=AlertRanges(warn=[1, None], crit=[None, None]),
                juggler_config=juggler_config
            )

            extra_alerts = EXTRA_ALERTS.get(c.domain, {}).get(c.component)
            yield c.panel_name + '-' + env.capitalize() + '-Alerts',\
                generate_alerts(responsibles=[], qloud_project_id=qloud_project_id, env=env,
                                configuration=c, alert_configuration=alert_config, extra_alerts=extra_alerts)
