def generate_tasks_panel(name, editors_list, qloud_project_id, qloud_component, env_list, default_env, task_names,
                         layout_height=1, layout_width=3, layout_columns_count=12):
    if task_names is None:
        task_names = []

    return '''<< suggest.clear() >>
<< suggest.add_var("env") >>
<< suggest.set_choice_list("env", [{envs}]) >>
<% set env = env | default("{default_env}") %>

<% set q_prj = "{qloud_project_id}" ~ "." ~ env %>

<% set q_component = "{qloud_component}" %>
<% if q_component != '' %>
    <% set q_component = 'tier=' ~ q_component ~ '*' %>
<% endif %>

<% set app_tag = "itype=qloud;prj=" ~ q_prj ~ ";" ~ q_component %>
<% set tasks = {tasks} %>
<% set main_layout = create_main_layout("vertical", default_height={layout_height}, default_width={layout_width}) %>
{{
    "title": "{panel_name} (<< env >>)",
    "type": "panel",
    "editors": [{editors}],
    "charts": [
        <% set primary_layout = main_layout.sub('flow', columns={layout_columns_count}) %>
        <% for task in tasks %>
        {{
            "title": "<< task >> statistic",
            "type": "graphic",
            "minValue": 0,
            "signals": [
                {{
                    "title": "active",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "unistat-task_<< task >>_active_count_ammm",
                    "color": "<< make_color(state, "sparse") >>"
                }},
                {{
                    "title": "duration, sec",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "conv(unistat-task_<< task >>_active_total_duration_ammm, 1000)",
                    "color": "<< make_color("total", "sparse") >>"
                }},
                <% set signal = 'unistat-task_' ~ task ~ '_error_axxx' %>
                {{
                    "title": "failure",
                    "tag": "<< app_tag >>",
                    "host": "QLOUD",
                    "name": "or(<< signal >>, 0)",
                    "color": "<< make_color("total", "sparse") >>",
                    <% set alert = list_alerts(signal_pattern=signal, hosts="QLOUD", itype="qloud", prj=q_prj, tier="{qloud_component}*").get() %>
                    <% if alert %>
                        "alertName": "<< alert >>"
                    <% endif %>
                }}
            ],
            << primary_layout.coords() >>
        }}
        << "," if not loop.last >>
        <%- endfor %>
    ]
}}'''.format(qloud_project_id=qloud_project_id,
             qloud_component=qloud_component or '',
             panel_name=name,
             editors=','.join(['"' + env + '"' for env in editors_list]),
             envs=','.join(['"' + env + '"' for env in env_list]),
             default_env=default_env,
             tasks=task_names,
             layout_columns_count=layout_columns_count,
             layout_height=layout_height,
             layout_width=layout_width)
