from mail.yasm.lib.commondb import get_dbaas_alerts_template
from mail.yasm.lib.cerberusdb.constants import CLUSTERS
from mail.yasm.lib.micronaut.alert import JugglerConfig, FlapsConfig


def primary_template():
    test_juggler_config = JugglerConfig(
        namespace='mail.cerberus',
        flaps_config=FlapsConfig(crit=600, stable=120),
        tags=['env_testing'],
    )
    prod_juggler_config = JugglerConfig(
        namespace='mail.cerberus',
        flaps_config=FlapsConfig(crit=300, stable=60),
        tags=['env_production'],
    )
    return (
        'Cerberusdb-dbaas-alerts',
        get_dbaas_alerts_template(
            name="cerberusdb",
            clusters=CLUSTERS,
            test_juggler_config=test_juggler_config,
            prod_juggler_config=prod_juggler_config
        )
    )
