FIELD_FOLDER = 'folder'
FIELD_ABC = 'abc'
FIELD_ESCALATION = 'escalation'
FIELD_ID = 'id'
FIELD_DBNAME = 'dbname'
JUGGLER_TEST = 'juggler_test'
JUGGLER_PROD = 'juggler_prod'
ABC_CALCORPBACK = 'calcorpback'
ABC_CALBACK = 'calback'
_SET_SIGNAL_SPACE = '''<% set signal_space_usage = 'perc(push-disk-used_bytes_pgdata_tmmx, push-disk-total_bytes_pgdata_tmmx)' %>
'''


def get_max_used_space_alert(warn_perc=85, crit_perc=90):
    return '''<< Alert(
                name=env ~ "." ~ q_ctype ~ ".max_used_space_percent",
                signal=signal_space_usage,
                tags={{
                    "itype": "mailpostgresql",
                    "tier": "primary",
                    "ctype": q_ctype,
                }},
                mgroups=["CON"],
                warn=[{warn}, {crit}],
                crit=[{crit}, None],
                juggler_check=juggler_dict[env]|merge_with_dict({{
                    "host": q_jhost,
                    "service": "max_used_space"
                }})
            )|merge_with_dict(abc) >>,
'''.format(warn=warn_perc, crit=crit_perc)


def get_replication_lag_alert(warn=10, crit=120):
    return '''<< Alert(
                name=env ~ "." ~ q_ctype ~ ".replication_lag",
                signal="push-postgres-replication_lag_tmmx",
                tags={{
                    "itype": "mailpostgresql",
                    "ctype": q_ctype,
                }},
                mgroups=["CON"],
                warn=[{warn}, {crit}],
                crit=[{crit}, None],
                juggler_check=juggler_dict[env]|merge_with_dict({{
                    "host": q_jhost,
                    "service": "replication_lag"
                }})
            )|merge_with_dict(abc) >>,
'''.format(warn=warn, crit=crit)


def get_trend_replication_lag_alert(warn_perc=1, crit_perc=2, interval=60, min_lag=10):
    return '''<< TrendAlert(
                name=env ~ "." ~ q_ctype ~ ".trend_replication_lag",
                signal="max(push-postgres-replication_lag_tmmx, {min_lag})",
                tags={{
                    "itype": "mailpostgresql",
                    "ctype": q_ctype,
                }},
                mgroups=["CON"],
                trend="up",
                interval={interval},
                warn_perc={warn},
                crit_perc={crit},
                juggler_check=juggler_dict[env]|merge_with_dict({{
                    "host": q_jhost,
                    "service": "trend_replication_lag"
                }})
            )|merge_with_dict(abc) >>,
'''.format(warn=warn_perc, crit=crit_perc, interval=interval, min_lag=min_lag)


def get_average_query_ms_alert(warn=50, crit=150):
    return '''<< Alert(
                name=env ~ "." ~ q_ctype ~ ".average_query_ms",
                signal="push-pooler-avg_query_time_vmmv",
                tags={{
                    "itype": "mailpostgresql",
                    "ctype": q_ctype,
                }},
                mgroups=["CON"],
                warn=[{warn}, {crit}],
                crit=[{crit}, None],
                juggler_check=juggler_dict[env]|merge_with_dict({{
                    "host": q_jhost,
                    "service": "average_query_ms"
                }})
            )|merge_with_dict(abc) >>,
'''.format(warn=warn, crit=crit)


def get_query_percentile_ms_alert(warn, crit, signal, name):
    return '''<< Alert(
                name=env ~ "." ~ q_ctype ~ ".{name}",
                signal="min({signal},push-pooler-avg_query_time_vmmv)",
                tags={{
                    "itype": "mailpostgresql",
                    "ctype": q_ctype,
                }},
                mgroups=["CON"],
                warn=[{warn}, {crit}],
                crit=[{crit}, None],
                juggler_check=juggler_dict[env]|merge_with_dict({{
                    "host": q_jhost,
                    "service": "{name}"
                }})
            )|merge_with_dict(abc) >>,
'''.format(warn=warn, crit=crit, signal=signal, name=name)


def get_query_75_percentile_ms_alert(warn=30, crit=40):
    return get_query_percentile_ms_alert(warn=warn, crit=crit, signal='push-pooler-query_0.75_vmmv', name='query_75_percentile_ms')


def get_sync_rep_wait_alert(warn=20, crit=100, window=20):
    return '''<< Alert(
                name=env ~ "." ~ q_ctype ~ ".sync_rep_wait_events",
                signal="push-postgres_wait_event_IPC_SyncRep_tmmx",
                tags={{
                    "itype": "mailpostgresql",
                    "ctype": q_ctype,
                }},
                mgroups=["CON"],
                warn=[{warn}, {crit}],
                crit=[{crit}, None],
                value_modify = {{
                    "type": "min",
                    "window": {window}
                }},
                juggler_check=juggler_dict[env]|merge_with_dict({{
                    "host": q_jhost,
                    "service": "sync_rep_wait_events"
                }})
            )|merge_with_dict(abc) >>,
'''.format(warn=warn, crit=crit, window=window)


def get_cpu_usage_alert(warn_perc=80, crit_perc=95):
    return '''<< Alert(
                name=env ~ "." ~ q_ctype ~ ".cpu_usage_percent",
                signal="perc(portoinst-cpu_usage_cores_txxx, portoinst-cpu_guarantee_cores_txxx)",
                tags={{
                    "itype": "mdbdom0",
                    "ctype": q_ctype,
                }},
                mgroups=["CON"],
                warn=[{warn}, {crit}],
                crit=[{crit}, None],
                juggler_check=juggler_dict[env]|merge_with_dict({{
                    "host": q_jhost,
                    "service": "cpu_usage_percent"
                }})
            )|merge_with_dict(abc) >>,
'''.format(warn=warn_perc, crit=crit_perc)


_DBAAS_ALERTS_NO_SHARDS_MAX_USED_SPACE_PERCENT = get_max_used_space_alert(warn_perc=85, crit_perc=90)
_DBAAS_ALERTS_NO_SHARDS_REPLICATION_LAG = get_replication_lag_alert(warn=10, crit=120)
_DBAAS_ALERTS_NO_SHARDS_TREND_REPLICATION_LAG = get_trend_replication_lag_alert(warn_perc=1, crit_perc=2, interval=60, min_lag=20)
_DBAAS_ALERTS_NO_SHARDS_AVERAGE_QUERY_MS = get_average_query_ms_alert(warn=50, crit=150)
_DBAAS_ALERTS_NO_SHARDS_QUERY_75_PERCENTILE_MS = get_query_75_percentile_ms_alert(warn=30, crit=40)
_DBAAS_ALERTS_NO_SHARDS_SYNC_REP_WAIT_EVENTS = get_sync_rep_wait_alert(warn=20, crit=100, window=300)
_DBAAS_ALERTS_NO_SHARDS_CPU_USAGE_PERCENT = get_cpu_usage_alert(warn_perc=80, crit_perc=95)

_DBAAS_ALERTS_NO_SHARDS = _DBAAS_ALERTS_NO_SHARDS_MAX_USED_SPACE_PERCENT + _DBAAS_ALERTS_NO_SHARDS_REPLICATION_LAG + \
    _DBAAS_ALERTS_NO_SHARDS_AVERAGE_QUERY_MS
_SET_VARIABLES_FOR_PANELS = '''<% set geo = geo|default(None) %>
<% set folder_id = folder_id_by_env[env] %>

<% set tags = "itype=mailpostgresql;prj=" ~ folder_id %>
<% set dom0_tags = "itype=mdbdom0;prj=" ~ folder_id %>
<% if ctype %>
    <% set tags = tags ~ ";ctype=" ~ ctype %>
    <% set dom0_tags = dom0_tags ~ ";ctype=" ~ ctype %>
<% endif %>
<% if geo %>
    <% set tags = tags ~ ";geo=" ~ geo %>
    <% set dom0_tags = dom0_tags ~ ";geo=" ~ geo %>
<% endif %>

<% set tier = tier | default(None) %>
<% set tiered_tags = tags %>
<% set tiered_dom0_tags = dom0_tags %>
<% if tier %>
    <% set tiered_tags = tiered_tags ~ ";tier=" ~ tier %>
    <% set tiered_dom0_tags = tiered_dom0_tags ~ ";tier=" ~ tier %>
<% endif %>

<% set dbname = dbname_by_env[env]|default('postgres') %>
'''
_SET_VARIABLES_FOR_PANELS_NON_SHARD = '''<% set ctype = cluster_id_by_env[env] %>
''' + _SET_VARIABLES_FOR_PANELS
_SET_VARIABLES_FOR_PANELS_SHARD = '''<% set ctype = ctype|default(None) %>
''' + _SET_VARIABLES_FOR_PANELS
_SET_VARIABLES_FOR_ALERTS_SHARDS = '''<% set q_ctypes = list_ctype(itype='mailpostgresql', prj=folder_id_by_env[env], limit=1000) %>
<% set abc = {'abc': abc_by_env[env]} %>
'''


def _get_dbaas_panels(name):
    return '''{
    "title": "''' + name + ''' in dbaas, env=<< env >>, tier=<< tier>>",
    "type": "panel",
    "editors": ["prez", "dskut"],
    "charts": [
        {
            "type": "graphic",
            "row": 1,
            "col": 1,
            "signals": [
                {

                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_guarantee_cores_tmmv",
                    "title": "guarantee",
                },
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_usage_cores_tmmv",
                    "title": "usage",
                },
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_limit_cores_tmmv",
                    "title": "limit",
                },
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-cpu_wait_cores_tmmv",
                    "title": "wait",
                }
            ],
            "title": "cpu usage",
            "normalize": true
        },
        {
            "type": "graphic",
            "row": 1,
            "col": 3,
            "signals": [
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-net_limit_mb_summ",
                    "title": "limit",
                },
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-net_guarantee_mb_summ",
                    "title": "guarantee",
                },
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "sum(portoinst-net_rx_mb_summ, portoinst-net_tx_mb_summ)",
                    "title": "used",
                }
            ],
            "title": "net usage",
            "normalize": true
        },
        {
            "type": "graphic",
            "row": 1,
            "col": 5,
            "signals": [
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-io_limit_bytes_tmmv",
                    "normalizable": true,
                    "title": "limit",
                },
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "round(portoinst-io_read_fs_bytes_tmmv)",
                    "normalizable": true,
                    "title": "read",
                },
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "round(portoinst-io_write_fs_bytes_tmmv)",
                    "normalizable": true,
                    "title": "write",
                }
            ],
            "title": "io usage, bytes",
            "normalize": true
        },
        {
            "id": "size",
            "type": "graphic",
            "row": 3,
            "column": 1,
            "minValue": 0,
            "signals": [
                {
                    "tag": "<< tags >>;tier=primary",
                    "host": "CON",
                    "name": "round(push-<< dbname >>_pg_database_size_vmmv)",
                    "title": "db size"
                },
                {
                    "tag": "<< tags >>;tier=primary",
                    "host": "CON",
                    "name": "round(push-disk-total_bytes_/var/lib/postgresql_vmmv)",
                    "title": "total space"
                },
                {
                    "tag": "<< tags >>;tier=primary",
                    "host": "CON",
                    "name": "round(push-disk-used_bytes_/var/lib/postgresql_vmmv)",
                    "title": "used space"
                },
                {
                    "title": "wal size",
                    "tag": "<< tags >>;tier=primary",
                    "host": "CON",
                    "name": "round(push-disk-path-size_pg_wal_bytes_vmmv)"
                },
                {
                    "title": "temp file size",
                    "tag": "<< tags >>;tier=primary",
                    "host": "CON",
                    "name": "round(push-disk-path-size_pgsql_tmp_bytes_vmmv)"
                }
            ],
            "title": "db size, bytes (on primary)",
            "stacked": false,
            "normalize": true
        },
        {
            "type": "graphic",
            "row": 3,
            "column": 3,
            "signals": [
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-memory_usage_gb_tmmv",
                    "title": "used"
                },
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-memory_guarantee_gb_tmmv",
                    "title": "guaranteed"
                },
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-memory_limit_gb_tmmv",
                    "title": "limit"
                },
                {
                    "tag": "<< tiered_dom0_tags >>",
                    "host": "CON",
                    "name": "portoinst-anon_usage_gb_tmmv",
                    "title": "anon used"
                }
            ],
            "title": "memory (gb)",
            "stacked": false,
            "normalize": true
        },
        {
            "type": "graphic",
            "row": 3,
            "column": 5,
            "signals": [
                {
                    "tag": "<< tags >>;tier=replica",
                    "host": "CON",
                    "name": "push-postgres-replication_lag_tmmx",
                    "title": "lag",
                },
            ],
            "title": "replication lag (on replicas)",
            "normalize": true
        },
        {
            "type": "graphic",
            "row": 5,
            "column": 1,
            "signals": [
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "or(push-postgres-log_warnings_tmmx, postgresql_log-log_warns_mmmm)",
                    "title": "warnings",
                },
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "or(push-postgres-log_errors_tmmx, postgresql_log-log_errors_mmmm)",
                    "title": "errors",
                },
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "or(push-postgres-log_fatals_tmmx, postgresql_log-log_fatals_mmmm)",
                    "title": "fatals",
                },
            ],
            "title": "log errors",
            "normalize": false
        },
        {
            "type": "graphic",
            "row": 5,
            "column": 3,
            "signals": [
                {
                    "tag": "<< tags >>;tier=primary",
                    "host": "CON",
                    "name": "push-postgres_wait_event_*"
                }
            ],
            "title": "wait event stat (on primary)",
            "stacked": true,
            "normalize": true,
        },
        {
            "type": "graphic",
            "row": 5,
            "column": 5,
            "signals": [
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-pooler-query_0.5_vmmv",
                },
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-pooler-query_0.75_vmmv",
                },
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-pooler-query_0.9_vmmv",
                },
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-pooler-query_0.95_vmmv",
                },
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-pooler-query_0.99_vmmv",
                },
            ],
            "title": "query time",
            "normalize": true
        },
        {
            "id": "rps",
            "type": "graphic",
            "row": 7,
            "column": 1,
            "minValue": 0,
            "signals": [
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-pooler-query_count_tmmx",
                    "title": "statements per second"
                },
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-pooler-xact_count_vmmv",
                    "title": "transactions per second"
                }
            ],
            "title": "rps",
            "stacked": false,
            "normalize": true
        },
        {
            "id": "connections",
            "type": "graphic",
            "row": 7,
            "column": 3,
            "signals": [
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-<< dbname >>_conn_active_vmmv",
                    "title": "active"
                },
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-<< dbname >>_conn_idle_vmmv",
                    "title": "idle"
                },
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-<< dbname >>_conn_idle_in_transaction_vmmv",
                    "title": "idle in transaction"
                },
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-<< dbname >>_conn_aborted_vmmv",
                    "title": "aborted"
                },
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-<< dbname >>_conn_waiting_vmmv",
                    "title": "waiting"
                },
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-pooler-total_tcp_connections_vmmv",
                    "title": "pooler tcp conn"
                }
            ],
            "title": "connections",
            "stacked": false,
            "normalize": true
        },
        {
            "type": "graphic",
            "row": 7,
            "column": 5,
            "signals": [
                {
                    "tag": "<< tiered_tags >>",
                    "host": "CON",
                    "name": "push-pooler-query_0.9-*_vmmv",
                },
            ],
            "title": "q90 query time by db user",
            "normalize": true
        },
    ]
}'''


def _get_dbaas_notifications(test_juggler_config, prod_juggler_config, responsibles):
    return '''
    <% set ''' + JUGGLER_TEST + ''' = ''' + str(test_juggler_config.to_jinja_dict(responsibles)) + ''' %>
    <% set ''' + JUGGLER_PROD + ''' = ''' + str(prod_juggler_config.to_jinja_dict(responsibles)) + ''' %>
    '''


def _get_cluster_field(clusters, field, wrap):
    return ",".join(map(lambda key: _get_row_field_as_pairs(clusters, key, field, wrap), clusters.keys()))


def _get_row_field_as_pairs(clusters, key, field, wrap):
    value = clusters[key][field]
    if wrap:
        return '"%s": "%s"' % (key, value)
    return '"%s": %s' % (key, value)


def _get_keys_as_string_array(clusters):
    return '[' + ','.join(map(lambda key: '"%s"' % key, clusters.keys())) + ']'


def _set_suggest_env(clusters, default_env):
    if default_env is None:
        default_env = next(iter(clusters.keys()))
    return '''<< suggest.clear() >>
<< suggest.add_var("env") >>
<< suggest.set_choice_list("env", {choice}) >>
<% set env = env|default("{default_env}") %>
'''.format(choice=_get_keys_as_string_array(clusters),
           default_env=default_env)


def _set_cluster_env(clusters):
    return '''<% set cluster_id_by_env = {{
{cluster_body}
}} %>
'''.format(cluster_body=_get_cluster_field(clusters, FIELD_ID, True))


def _set_folder_env(clusters):
    return '''<% set folder_id_by_env = {{
{cluster_body}
}} %>
'''.format(cluster_body=_get_cluster_field(clusters, FIELD_FOLDER, True))


def _set_juggler_dict(clusters):
    return '''<% set juggler_dict = {{
{cluster_body}
}} %>
'''.format(cluster_body=_get_cluster_field(clusters, FIELD_ESCALATION, False))


def _set_dbname_env(clusters):
    kv = []
    for key in clusters.keys():
        if FIELD_DBNAME in clusters[key]:
            value = clusters[key][FIELD_DBNAME]
            kv += ['"%s": "%s"' % (key, value)]
    return '''<% set dbname_by_env = {{
{dbname}
}} %>
'''.format(dbname=",".join(kv))


def _set_abc_env(clusters):
    return '''<% set abc_by_env = {{
{cluster_body}
}} %>
'''.format(cluster_body=_get_cluster_field(clusters, FIELD_ABC, True))


def _generate_for_env(clusters, body):
    return '''<% for env in {choice} %>
{body}
<% endfor %>
'''.format(choice=_get_keys_as_string_array(clusters), body=body)


def _set_variables_for_alerts_non_shard(name):
    return '''<% set q_ctype = cluster_id_by_env[env] %>
<% set abc = {{'abc': abc_by_env[env]}} %>
<% set q_jhost = "mail.{name}.dbaas." ~ env %>
<% set folder_id = folder_id_by_env[env] %>
'''.format(name=name)


def _get_total_replication_lag_alert(name):
    return '''<< Alert(
            name=env ~ ".total.replication_lag",
            signal="push-postgres-replication_lag_tmmx",
            tags={
                "itype": "mailpostgresql",
                "prj": folder_id_by_env[env],
            },
            mgroups=["CON"],
            warn=[150, 300],
            crit=[300, None],
            juggler_check=juggler_dict[env]|merge_with_dict({
                "host": "mail.''' + name + '''.dbaas." ~ env,
                "service": "total_replication_lag"
            })
        )|merge_with_dict(abc) >>,
'''


def _generate_for_ctype(name, prefix, body):
    return '''{prefix}<% for q_ctype in q_ctypes %>
<% set q_jhost = "mail.{name}.dbaas." ~ env ~ "." ~ q_ctype %>
{body}
<% endfor %>
'''.format(prefix=prefix, name=name, body=body)


def get_dbaas_alerts_template(name, clusters, test_juggler_config, prod_juggler_config, responsibles=None, alerts=None):
    """This function generates alerts in case the clusters ids
    are known apriori, i.e. no sharding envolved"""
    if alerts is None:
        alerts = _DBAAS_ALERTS_NO_SHARDS
    prefix = _set_variables_for_alerts_non_shard(name)
    template = [
        _get_dbaas_notifications(
            test_juggler_config=test_juggler_config,
            prod_juggler_config=prod_juggler_config,
            responsibles=responsibles
        ),
        _set_juggler_dict(clusters),
        _SET_SIGNAL_SPACE,
        _set_folder_env(clusters),
        _set_cluster_env(clusters),
        _set_abc_env(clusters),
        _generate_for_env(clusters, prefix + alerts)
    ]
    return '[' + "".join(template) + ']'


def get_dbaas_alerts_template_shards(name, environments, test_juggler_config, prod_juggler_config, alert_group,
                                     extra_alerts_for_env='', responsibles=None):
    """This function generates alerts in case the clusters ids
    are not known apriori due to the nature of dynamic sharding,
    it also adds total_replication_lag alert."""
    for_ctype = _generate_for_ctype(name, _SET_VARIABLES_FOR_ALERTS_SHARDS,
                                    alert_group)
    template = [
        _get_dbaas_notifications(
            test_juggler_config=test_juggler_config,
            prod_juggler_config=prod_juggler_config,
            responsibles=responsibles
        ),
        _set_juggler_dict(environments),
        _SET_SIGNAL_SPACE,
        _set_folder_env(environments),
        _set_abc_env(environments),
        _generate_for_env(environments, for_ctype + extra_alerts_for_env)
    ]
    return '[' + "".join(template) + ']'


def get_dbaas_panels_template(name, clusters, default_environment_name=None):
    """This function generates panels in case the clusters ids
    are known apriori, i.e. no sharding envolved"""
    template = [
        _set_suggest_env(clusters, default_environment_name),
        _set_cluster_env(clusters),
        _set_folder_env(clusters),
        _set_dbname_env(clusters),
        _SET_VARIABLES_FOR_PANELS_NON_SHARD,
        _get_dbaas_panels(name)
    ]
    return "".join(template)


def get_dbaas_panels_template_shards(name, environments, default_environment_name=None):
    """This function generates panels in case the clusters ids
    are not known apriori due to the nature of dynamic sharding"""
    if default_environment_name is None:
        default_environment_name = next(iter(environments.keys()))
    template = [
        _set_suggest_env(environments, default_environment_name),
        _set_folder_env(environments),
        _set_dbname_env(environments),
        _SET_VARIABLES_FOR_PANELS_SHARD,
        _get_dbaas_panels(name)
    ]
    return "".join(template)
