LOG_PANEL_TEMPLATE = r'''
<% set proj = "mail.doberman-corp.production,mail.doberman-corp.prestable" %>
<% set all_shards = list_ctype(itype="qloud", hosts="QLOUD", prj=proj, component="doberman") %>
<% set unknown = ['unknown', 'unknownshard'] %>

<< suggest.clear() >>
<< suggest.set_choice_list("shard", ["all"]) >>
<< suggest.add_choice_list("shard", all_shards) >>
<< suggest.remove_choice_list("shard", unknown) >>

<% set shard = shard | default("all") %>

<% if shard == "all" %>
    <% set is_single = false %>
    <% set shards = all_shards %>
<% else %>
    <% set is_single = true %>
    <% set shards = [ shard ] %>
<% endif %>

<% set errors = [
    'logic',
    'apq',
    'macs',
    'pg_common',
    'pg_connection',
    'pg_readonly',
    'pg_database',
    'pg_repository',
    'pg_sql',
    'sharpei_client',
    'unexpected'
] %>
<% set notices = [
    'ignore',
    'retry',
] %>

<% set main = create_main_layout("vertical") %>
<% set flow = main.sub("flow", columns = 6) %>

{
    "title": "doberman log errors",
    "type": "panel",
    "key": "doberman_log_errors",
    "editors": [],
    "charts": [
        {
            "type": "text",
            "text": "errors",
            << flow.coords(width = 6, height = 0.3) >>,
        },
        <% for err in errors %>
        {
            "type": "graphic",
            << flow.coords(width = 2, height = 1) >>,
            "title": "<< err >> errors, rps",
            "normalize": false,
            "stacked": true,
            "signals": [
                <% for sh in shards %>
                <% if single_shard or sh not in unknown %>
                {
                    "title": "<< sh >>",
                    "tag": "itype=qloud;ctype=<< sh >>;prj=<< proj >>",
                    "host": "QLOUD",
                    "name": "unistat-<< err >>_error_ammm"
                },
                <% endif %>
                <% endfor %>
            ],
            "consts": []
        },
        <% endfor %>
        {
            "type": "text",
            "text": "notices",
            << flow.coords(width = 6, height = 0.3) >>,
        },
        <% for notice in notices %>
        {
            "type": "graphic",
            << flow.coords(width = 2, height = 1) >>,
            "title": "<< notice >> changes",
            "normalize": false,
            "stacked": true,
            "signals": [
                <% for sh in shards %>
                <% if single_shard or sh not in unknown %>
                {
                    "title": "<< sh >>",
                    "tag": "itype=qloud;ctype=<< sh >>;prj=<< proj >>",
                    "host": "QLOUD",
                    "name": "unistat-<< notice >>_notice_ammm"
                },
                <% endif %>
                <% endfor %>
            ],
            "consts": []
        },
        <% endfor %>
   ],
}
'''


def log_template():
    return 'doberman_log_errors', LOG_PANEL_TEMPLATE
