PA_PANEL_TEMPLATE = r'''
<% set proj = "mail.doberman-corp.production,mail.doberman-corp.prestable" %>
<% set all_shards = list_ctype(itype="qloud", hosts="QLOUD", prj=proj, component="doberman") %>
<% set unknown = ['unknown', 'unknownshard'] %>

<< suggest.clear() >>
<< suggest.set_choice_list("shard", ["all"]) >>
<< suggest.add_choice_list("shard", all_shards) >>
<< suggest.remove_choice_list("shard", unknown) >>

<% set shard = shard | default("all") %>

<% if shard == "all" %>
    <% set is_single = false %>
    <% set shards = all_shards %>
<% else %>
    <% set is_single = true %>
    <% set shards = [ shard ] %>
<% endif %>

<% set operations = [
    'init_subscribe_copy',
    'query_init_store',
    'query_fetch_envelopes',
    'change_apply_put',
    'change_apply_move',
    'change_apply_remove',
    'change_apply_erase',
    'change_apply_update',
    'change_apply_join_threads',
    'unsubscribe_clear',
    'query_clear',
    'change_cache_fetch',
    'change_log_cache_fetch',
] %>

<% set main = create_main_layout("vertical") %>
<% set flow = main.sub("flow", columns = 6) %>

{
    "title": "doberman pa",
    "type": "panel",
    "key": "doberman_pa",
    "editors": [],
    "charts": [
        <% for op in operations %>
        {
            "type": "graphic",
            << flow.coords(width = 2, height = 1) >>,
            "title": "<< op >>, count",
            "normalize": false,
            "signals": [
                <% for sh in shards %>
                <% if single_shard or sh not in unknown %>
                {
                    "title": "<< sh >>",
                    "tag": "itype=qloud;ctype=<< sh >>;prj=<< proj >>",
                    "host": "QLOUD",
                    "name": "unistat-<< op >>_count_ammm"
                },
                <% endif %>
                <% endfor %>
            ],
            "consts": []
        },
        {
            "type": "graphic",
            << flow.coords(width = 2, height = 1) >>,
            "title": "<< op >>, max times, sec",
            "normalize": false,
            "signals": [
                <% for sh in shards %>
                <% if single_shard or sh not in unknown %>
                {
                    "title": "<< sh >>",
                    "tag": "itype=qloud;ctype=<< sh >>;prj=<< proj >>",
                    "host": "QLOUD",
                    "name": "div(max(unistat-<< op >>_time_max_axxx),const(1000))"
                },
                <% endif %>
                <% endfor %>
            ],
            "consts": []
        },
        {
            "type": "graphic",
            << flow.coords(width = 2, height = 1) >>,
            "title": "<< op >>, aver times, sec",
            "normalize": false,
            "signals": [
                <% for sh in shards %>
                <% if single_shard or sh not in unknown %>
                {
                    "title": "<< sh >>",
                    "tag": "itype=qloud;ctype=<< sh >>;prj=<< proj >>",
                    "host": "QLOUD",
                    "name": "div(aver(unistat-<< op >>_time_avg_avvv),const(1000))"
                },
                <% endif %>
                <% endfor %>
            ],
            "consts": []
        },
        <% endfor %>
    ],
}
'''


def pa_template():
    return 'doberman_pa', PA_PANEL_TEMPLATE
