from importlib import import_module

import requests

YASM_ENDPOINT = "https://yasm.yandex-team.ru/srvambry/"


def gen_alert(name, template, owners, create_if_not_exists=True):
    result = requests.post(
        YASM_ENDPOINT + "tmpl/alerts/update?key={alert}".format(alert=name),
        headers={"Content-Type": "application/json"},
        json={
            "key": name,
            "owners": owners,
            "content": template,
        },
    )
    print(result.status_code)

    if result.status_code == 404 and create_if_not_exists:
        print('alert ' + name + " not found, let's create it")
        result = requests.post(
            YASM_ENDPOINT + "tmpl/alerts/create",
            headers={"Content-Type": "application/json"},
            json={
                "key": name,
                "owners": owners
            }
        )
        print(result.status_code, result.text)
        if result.status_code == 200:
            return gen_alert(name, template, owners, create_if_not_exists=False)
        else:
            return False
    elif result.status_code != 200:
        print(result.text)
        return False

    result = requests.post(YASM_ENDPOINT + "tmpl/alerts/apply/{alert}".format(alert=name))
    print(result.status_code, result.text)
    assert result.status_code == 200
    return True


def gen_panel(name, template, owners, create_if_not_exists=True):
    result = requests.post(
        YASM_ENDPOINT + "tmpl/panels/update/content?key={panel}".format(panel=name),
        headers={"Content-Type": "application/json"},
        data=template
    )
    print(result.status_code)

    if result.status_code == 404 and create_if_not_exists:
        print('panel ' + name + " not found, let's create it")
        result = requests.post(
            YASM_ENDPOINT + "tmpl/panels/create",
            headers={"Content-Type": "application/json"},
            json={
                "key": name,
                "owners": owners
            }
        )
        print(result.status_code, result.text)
        if result.status_code == 200:
            return gen_panel(name, template, owners, create_if_not_exists=False)

    if result.status_code != 200:
        print(result.text)
        return False
    else:
        return True


def gen(projects, owners):
    for project in projects:
        print('generate alerts for ' + project)
        project_module = import_module('mail.yasm.lib.{project}'.format(project=project))
        for (alert, template) in project_module.alert_templates():
            print('alert ' + alert)
            if not gen_alert(name=alert, template=template, owners=owners):
                return
        print('alerts generation done')

        print('generate panels for ' + project)
        for (panel, template) in project_module.panel_templates():
            print('panel ' + panel)
            if not gen_panel(name=panel, template=template, owners=owners):
                return
        print('panels generation done')
